/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.EventHandler;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.AbstractResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.LoggingUtils;
import java.util.List;
import java.util.Optional;

abstract class AbstractEventsResponseBulkHandler<T>
extends AbstractResponseHandler {
    private final EventHandler<List<T>> delegate;

    AbstractEventsResponseBulkHandler(EventTypePartition eventTypePartition, PartitionCoordinator coordinator, Class<?> loggerClazz, ObjectMapper jsonMapper, EventHandler<List<T>> delegate) {
        super(eventTypePartition, coordinator, LoggingUtils.getLogger(loggerClazz, eventTypePartition), jsonMapper);
        this.delegate = delegate;
    }

    @Override
    public void onResponse(String content) {
        String[] events;
        for (String event : events = this.getEvents(content)) {
            Optional<NakadiEventBatch<T>> optionalBatch = this.getEventBatch(event);
            if (!optionalBatch.isPresent()) {
                return;
            }
            EventTypeCursor cursor = EventTypeCursor.of(this.eventTypePartition, optionalBatch.get().getCursor().getOffset());
            List<T> batchEvents = optionalBatch.get().getEvents();
            if (null != batchEvents && !batchEvents.isEmpty()) {
                this.handleEvents(cursor, batchEvents);
                continue;
            }
            try {
                this.log.info("Keep alive offset [{}]", (Object)cursor.getOffset());
                this.coordinator.commit(cursor);
            }
            catch (Throwable t) {
                this.log.error("Handler error at cursor [{}]", (Object)cursor);
                this.coordinator.error(t, this.eventTypePartition);
            }
        }
    }

    private void handleEvents(EventTypeCursor cursor, List<T> events) {
        try {
            this.delegate.onEvent(cursor, events);
            this.coordinator.commit(cursor);
        }
        catch (Throwable t) {
            this.log.error("Handler error at cursor [{}]", (Object)cursor);
            this.coordinator.error(t, this.eventTypePartition);
        }
    }

    abstract Optional<NakadiEventBatch<T>> getEventBatch(String var1);
}

