/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventCursor;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.ResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;

abstract class AbstractResponseHandler
implements ResponseHandler {
    private static final String BATCH_SEPARATOR = "\n";
    protected final Logger log;
    protected final ObjectMapper jsonMapper;
    protected final EventTypePartition eventTypePartition;
    protected final PartitionCoordinator coordinator;

    AbstractResponseHandler(EventTypePartition eventTypePartition, PartitionCoordinator coordinator, Logger log, ObjectMapper jsonMapper) {
        this.eventTypePartition = eventTypePartition;
        this.coordinator = coordinator;
        this.log = log;
        this.jsonMapper = jsonMapper;
    }

    String[] getEvents(String string) {
        return string.split(BATCH_SEPARATOR);
    }

    Optional<NakadiEventCursor> getEventCursor(String string) {
        try {
            return Optional.of(this.jsonMapper.readValue(string, NakadiEventCursor.class));
        }
        catch (IOException e) {
            this.log.error("Error while parsing event cursor from [{}]", (Object)string, (Object)e);
            return Optional.empty();
        }
    }
}

