/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.EventHandler;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.AbstractResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.LoggingUtils;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractEventsResponseHandler<T>
extends AbstractResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventsResponseHandler.class);
    private final EventHandler<T> delegate;

    AbstractEventsResponseHandler(EventTypePartition eventTypePartition, PartitionCoordinator coordinator, Class<?> loggerClazz, ObjectMapper jsonMapper, EventHandler<T> delegate) {
        super(eventTypePartition, coordinator, LoggingUtils.getLogger(loggerClazz, eventTypePartition), jsonMapper);
        this.delegate = delegate;
    }

    @Override
    public void onResponse(String content) {
        String[] events;
        for (String event : events = this.getEvents(content)) {
            Optional<NakadiEventBatch<T>> optionalBatch = this.getEventBatch(event);
            if (!optionalBatch.isPresent()) {
                return;
            }
            EventTypeCursor cursor = EventTypeCursor.of(this.eventTypePartition, optionalBatch.get().getCursor().getOffset());
            List<T> batchEvents = optionalBatch.get().getEvents();
            if (null != batchEvents && !batchEvents.isEmpty()) {
                this.handleEvents(cursor, batchEvents);
                continue;
            }
            try {
                this.log.info("Keep alive offset [{}]", (Object)cursor.getOffset());
                this.coordinator.commit(cursor);
            }
            catch (Throwable t) {
                this.log.error("Handler error at cursor [{}]", (Object)cursor);
                this.coordinator.error(t, this.eventTypePartition);
            }
        }
    }

    private void handleEvents(EventTypeCursor cursor, List<T> events) {
        for (int i = 0; i < events.size(); ++i) {
            EventTypeCursor commitCursor = this.decreaseCursor(cursor, events.size() - (i + 1));
            try {
                this.delegate.onEvent(commitCursor, events.get(i));
                this.coordinator.commit(commitCursor);
                continue;
            }
            catch (Throwable t) {
                this.log.error("Handler error at cursor [{}]", (Object)commitCursor);
                this.coordinator.error(t, this.eventTypePartition);
            }
        }
    }

    private EventTypeCursor decreaseCursor(EventTypeCursor cursor, int n) {
        if (n > 0) {
            try {
                long nextOffset = Long.parseLong(cursor.getOffset()) - (long)n;
                return EventTypeCursor.of(cursor.getEventTypePartition(), Long.toString(nextOffset));
            }
            catch (NumberFormatException ignore) {
                LOGGER.warn("Cannot advance cursor [{}] by [{}] due to [{}]", new Object[]{cursor, n, ExceptionUtils.getMessage((Throwable)ignore)});
                return cursor;
            }
        }
        return cursor;
    }

    abstract Optional<NakadiEventBatch<T>> getEventBatch(String var1);
}

