/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.AbstractEventsResponseBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.BatchEventsBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.EventClassProvider;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import java.io.IOException;
import java.util.Optional;

public class BatchEventsResponseBulkHandler<T>
extends AbstractEventsResponseBulkHandler<T> {
    private final JavaType javaType;

    public BatchEventsResponseBulkHandler(EventTypePartition eventTypePartition, ObjectMapper jsonMapper, PartitionCoordinator coordinator, BatchEventsBulkHandler<T> delegate) {
        super(eventTypePartition, coordinator, BatchEventsResponseBulkHandler.class, jsonMapper, delegate);
        this.javaType = EventClassProvider.getJavaType(delegate, jsonMapper);
    }

    @Override
    Optional<NakadiEventBatch<T>> getEventBatch(String string) {
        try {
            return Optional.of(this.jsonMapper.readValue(string, this.javaType));
        }
        catch (IOException e) {
            this.log.error("Error while parsing event batch from [{}]", (Object)string, (Object)e);
            return Optional.empty();
        }
    }
}

