/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import de.zalando.paradox.nakadi.consumer.core.ConsumerConfig;
import de.zalando.paradox.nakadi.consumer.core.DefaultObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.EventStreamConfig;
import de.zalando.paradox.nakadi.consumer.core.client.Client;
import de.zalando.paradox.nakadi.consumer.core.domain.EventType;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiPartition;
import de.zalando.paradox.nakadi.consumer.core.http.HttpResponseChunk;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.EventUtils;
import de.zalando.paradox.nakadi.consumer.core.http.okhttp.RxHttpRequest;
import de.zalando.paradox.nakadi.consumer.core.http.requests.HttpGetEvents;
import de.zalando.paradox.nakadi.consumer.core.http.requests.HttpGetPartitions;
import de.zalando.paradox.nakadi.consumer.core.utils.ThrowableUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;
import rx.Single;

public class ClientImpl
implements Client {
    private final String nakadiUrl;
    private final ObjectMapper objectMapper;
    private final AuthorizationValueProvider authorizationValueProvider;
    private final long partitionsTimeoutMillis;
    private final long eventsTimeoutMillis;

    public ClientImpl(Builder builder) {
        this.nakadiUrl = Objects.requireNonNull(builder.nakadiUrl, "nakadiUrl must not be null");
        this.objectMapper = Objects.requireNonNull(builder.objectMapper, "objectMapper must not be null");
        this.authorizationValueProvider = builder.authorizationValueProvider;
        this.partitionsTimeoutMillis = builder.partitionsTimeoutMillis;
        this.eventsTimeoutMillis = builder.eventsTimeoutMillis;
    }

    public ClientImpl(ConsumerConfig consumerConfig) {
        this.nakadiUrl = consumerConfig.getNakadiUrl();
        this.objectMapper = consumerConfig.getObjectMapper();
        this.authorizationValueProvider = consumerConfig.getAuthorizationValueProvider();
        this.partitionsTimeoutMillis = consumerConfig.getPartitionsTimeoutMillis();
        this.eventsTimeoutMillis = consumerConfig.getEventsTimeoutMillis();
    }

    @Override
    public Single<List<NakadiPartition>> getPartitions(EventType eventType) {
        HttpGetPartitions httpGetPartitions = new HttpGetPartitions(this.nakadiUrl, eventType);
        Observable<HttpResponseChunk> request = new RxHttpRequest(this.partitionsTimeoutMillis, this.authorizationValueProvider).createRequest(httpGetPartitions);
        return request.filter(chunk -> {
            Preconditions.checkArgument((chunk.getStatusCode() == 200 ? 1 : 0) != 0, (String)"Get partitions for event [%s] , result [%s / %s]", (Object[])new Object[]{eventType, chunk.getStatusCode(), chunk.getContent()});
            return true;
        }).map(chunk -> this.getPartitions(chunk.getContent())).firstOrDefault(Collections.emptyList()).toSingle();
    }

    private List<NakadiPartition> getPartitions(String content) {
        try {
            return (List)this.objectMapper.readValue(content, (TypeReference)new TypeReference<ArrayList<NakadiPartition>>(){});
        }
        catch (IOException e) {
            ThrowableUtils.throwException(e);
            return null;
        }
    }

    @Override
    public Single<String> getEvent(EventTypeCursor cursor) {
        Observable<HttpResponseChunk> request = this.getContent0(cursor, 1);
        return request.map(chunk -> this.getEvent0(chunk.getContent())).firstOrDefault(null).toSingle();
    }

    @Override
    public Single<String> getContent(EventTypeCursor cursor) {
        Observable<HttpResponseChunk> request = this.getContent0(cursor, 1);
        return request.map(HttpResponseChunk::getContent).firstOrDefault(null).toSingle();
    }

    private Observable<HttpResponseChunk> getContent0(EventTypeCursor cursor, int streamLimit) {
        Preconditions.checkArgument((streamLimit > 0 ? 1 : 0) != 0, (Object)"streamLimit must be greater than 0");
        EventStreamConfig eventStreamConfig = new EventStreamConfig.Builder().withStreamLimit(streamLimit).build();
        HttpGetEvents httpGetEvents = new HttpGetEvents(this.nakadiUrl, cursor, eventStreamConfig);
        return new RxHttpRequest(this.eventsTimeoutMillis, this.authorizationValueProvider).createRequest(httpGetEvents).filter(chunk -> {
            Preconditions.checkArgument((chunk.getStatusCode() == 200 ? 1 : 0) != 0, (String)"Get for cursor [%s] , result [%s / %s]", (Object[])new Object[]{cursor, chunk.getStatusCode(), chunk.getContent()});
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)chunk.getContent()), (String)"Event not found for cursor [%s]", (Object[])new Object[]{cursor});
            return true;
        });
    }

    private String getEvent0(String content) {
        NakadiEventBatch<String> events = EventUtils.getRawEventBatch(this.objectMapper, content);
        Preconditions.checkArgument((events != null ? 1 : 0) != 0);
        return (String)Iterables.getOnlyElement(events.getEvents());
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static class Builder {
        private final String nakadiUrl;
        private ObjectMapper objectMapper = new DefaultObjectMapper().jacksonObjectMapper();
        private long eventsTimeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        private long partitionsTimeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        private AuthorizationValueProvider authorizationValueProvider;

        public Builder(String nakadiUrl) {
            this.nakadiUrl = nakadiUrl;
        }

        public static Builder of(String nakadiUrl) {
            return new Builder(nakadiUrl);
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder withAuthorization(AuthorizationValueProvider authorizationValueProvider) {
            this.authorizationValueProvider = authorizationValueProvider;
            return this;
        }

        public Builder withEventsTimeoutMillis(long eventsTimeoutMillis) {
            this.eventsTimeoutMillis = eventsTimeoutMillis;
            return this;
        }

        public Builder withPartitionsTimeoutMillis(long partitionsTimeoutMillis) {
            this.partitionsTimeoutMillis = partitionsTimeoutMillis;
            return this;
        }

        public ClientImpl build() {
            return new ClientImpl(this);
        }
    }
}

