/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventCursor;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.AbstractResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawContentHandler;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.LoggingUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawContentResponseHandler
extends AbstractResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawContentResponseHandler.class);
    private final RawContentHandler delegate;

    public RawContentResponseHandler(EventTypePartition eventTypePartition, ObjectMapper jsonMapper, PartitionCoordinator coordinator, RawContentHandler delegate) {
        super(eventTypePartition, coordinator, LoggingUtils.getLogger(RawContentResponseHandler.class, eventTypePartition), jsonMapper);
        this.delegate = delegate;
    }

    @Override
    public void onResponse(String content) {
        String[] events = this.getEvents(content);
        if (events.length > 0) {
            NakadiEventCursor nakadiFirstCursor = Objects.requireNonNull(this.getEventCursor(events[0]), "Nakadi event cursor must not be null!");
            NakadiEventCursor nakadiLastCursor = events.length > 1 ? this.getEventCursor(events[events.length - 1]) : nakadiFirstCursor;
            EventTypeCursor firstCursor = EventTypeCursor.of(this.eventTypePartition, nakadiFirstCursor.getCursor().getOffset());
            EventTypeCursor lastCursor = EventTypeCursor.of(this.eventTypePartition, nakadiLastCursor.getCursor().getOffset());
            Preconditions.checkArgument((boolean)firstCursor.getPartition().equals(lastCursor.getPartition()), (String)"Cursor partitions differ [%s] vs [%s]", (Object[])new Object[]{firstCursor.getPartition(), lastCursor.getPartition()});
            try {
                this.delegate.onEvent(lastCursor, content);
            }
            catch (Throwable t) {
                LOGGER.error("Handler error at firstCursor [{}] , lastCursor [{}]", (Object)firstCursor, (Object)lastCursor);
                this.coordinator.error(t, this.eventTypePartition, lastCursor.getOffset(), content);
            }
            this.coordinator.commit(lastCursor);
        }
    }
}

