/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core;

public class EventStreamConfig {
    private final Integer batchLimit;
    private final Integer streamLimit;
    private final Integer batchTimeoutSeconds;
    private final Integer streamTimeoutSeconds;
    private final Integer streamKeepAliveLimit;

    private EventStreamConfig(Builder builder) {
        this.batchLimit = builder.batchLimit;
        this.streamLimit = builder.streamLimit;
        this.batchTimeoutSeconds = builder.batchTimeoutSeconds;
        this.streamTimeoutSeconds = builder.streamTimeoutSeconds;
        this.streamKeepAliveLimit = builder.streamKeepAliveLimit;
    }

    public Integer getBatchLimit() {
        return this.batchLimit;
    }

    public Integer getStreamLimit() {
        return this.streamLimit;
    }

    public Integer getBatchTimeoutSeconds() {
        return this.batchTimeoutSeconds;
    }

    public Integer getStreamTimeoutSeconds() {
        return this.streamTimeoutSeconds;
    }

    public Integer getStreamKeepAliveLimit() {
        return this.streamKeepAliveLimit;
    }

    public static class Builder {
        private Integer batchLimit;
        private Integer streamLimit;
        private Integer batchTimeoutSeconds;
        private Integer streamTimeoutSeconds;
        private Integer streamKeepAliveLimit;

        public static Builder of() {
            return new Builder();
        }

        public Builder withBatchLimit(Integer batchLimit) {
            this.batchLimit = batchLimit;
            return this;
        }

        public Builder withStreamLimit(Integer streamLimit) {
            this.streamLimit = streamLimit;
            return this;
        }

        public Builder withBatchTimeoutSeconds(Integer batchTimeoutSeconds) {
            this.batchTimeoutSeconds = batchTimeoutSeconds;
            return this;
        }

        public Builder withStreamTimeoutSeconds(Integer streamTimeoutSeconds) {
            this.streamTimeoutSeconds = streamTimeoutSeconds;
            return this;
        }

        public Builder withStreamKeepAliveLimit(Integer streamKeepAliveLimit) {
            this.streamKeepAliveLimit = streamKeepAliveLimit;
            return this;
        }

        public EventStreamConfig build() {
            return new EventStreamConfig(this);
        }
    }
}

