/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import de.zalando.paradox.nakadi.consumer.core.DefaultObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.EventStreamConfig;
import de.zalando.paradox.nakadi.consumer.core.domain.EventType;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.BatchEventsBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.BatchEventsHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.BatchEventsResponseBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.BatchEventsResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.JsonEventBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.JsonEventHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.JsonEventResponseBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.JsonEventResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawContentHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawContentResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawEventBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawEventHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawEventResponseBulkHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.RawEventResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.ResponseHandlerFactory;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ConsumerConfig {
    private final String nakadiUrl;
    private final EventType eventType;
    private final ObjectMapper objectMapper;
    private final long eventsTimeoutMillis;
    private final long eventsRetryAfterMillis;
    private final long eventsRetryRandomMillis;
    private final EventStreamConfig eventStreamConfig;
    private final long partitionsTimeoutMillis;
    private final long partitionsRetryRandomMillis;
    private final long partitionsRetryAfterMillis;
    private final AuthorizationValueProvider authorizationValueProvider;
    private final PartitionCoordinator partitionCoordinator;
    private final ResponseHandlerFactory responseHandlerFactory;

    private ConsumerConfig(Builder builder) {
        this.nakadiUrl = Objects.requireNonNull(builder.nakadiUrl, "nakadiUrl must not be null");
        this.eventType = Objects.requireNonNull(builder.eventType, "eventType must not be null");
        this.objectMapper = Objects.requireNonNull(builder.objectMapper, "objectMapper must not be null");
        this.eventsTimeoutMillis = builder.eventsTimeoutMillis;
        this.eventsRetryAfterMillis = builder.eventsRetryAfterMillis;
        this.eventsRetryRandomMillis = builder.eventsRetryRandomMillis;
        this.eventStreamConfig = builder.eventStreamConfig;
        this.partitionsTimeoutMillis = builder.partitionsTimeoutMillis;
        this.partitionsRetryAfterMillis = builder.partitionsRetryAfterMillis;
        this.partitionsRetryRandomMillis = builder.partitionsRetryRandomMillis;
        this.authorizationValueProvider = builder.authorizationValueProvider;
        this.partitionCoordinator = Objects.requireNonNull(builder.partitionCoordinator, "partitionCoordinator must not be null");
        this.responseHandlerFactory = Objects.requireNonNull(builder.responseHandlerFactory, "responseHandlerFactory must not be null");
    }

    public String getNakadiUrl() {
        return this.nakadiUrl;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public long getEventsTimeoutMillis() {
        return this.eventsTimeoutMillis;
    }

    public long getEventsRetryAfterMillis() {
        return this.eventsRetryAfterMillis;
    }

    public long getEventsRetryRandomMillis() {
        return this.eventsRetryRandomMillis;
    }

    public long getPartitionsTimeoutMillis() {
        return this.partitionsTimeoutMillis;
    }

    public long getPartitionsRetryAfterMillis() {
        return this.partitionsRetryAfterMillis;
    }

    public long getPartitionsRetryRandomMillis() {
        return this.partitionsRetryRandomMillis;
    }

    public AuthorizationValueProvider getAuthorizationValueProvider() {
        return this.authorizationValueProvider;
    }

    public PartitionCoordinator getPartitionCoordinator() {
        return this.partitionCoordinator;
    }

    public ResponseHandlerFactory getResponseHandlerFactory() {
        return this.responseHandlerFactory;
    }

    public EventStreamConfig getEventStreamConfig() {
        return this.eventStreamConfig;
    }

    public static class Builder {
        private final String nakadiUrl;
        private final EventType eventType;
        private ObjectMapper objectMapper = Builder.defaultObjectMapper();
        private long eventsTimeoutMillis = TimeUnit.SECONDS.toMillis(120L);
        private long eventsRetryAfterMillis = TimeUnit.SECONDS.toMillis(2L);
        private long eventsRetryRandomMillis = TimeUnit.SECONDS.toMillis(0L);
        private EventStreamConfig eventStreamConfig;
        private long partitionsTimeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        private long partitionsRetryAfterMillis = TimeUnit.SECONDS.toMillis(15L);
        private long partitionsRetryRandomMillis = TimeUnit.SECONDS.toMillis(5L);
        private AuthorizationValueProvider authorizationValueProvider;
        private final PartitionCoordinator partitionCoordinator;
        private ResponseHandlerFactory responseHandlerFactory;

        public Builder(String nakadiUrl, String eventName, PartitionCoordinator partitionCoordinator) {
            this.nakadiUrl = nakadiUrl;
            this.eventType = EventType.of(Objects.requireNonNull(eventName, "eventName must not be null"));
            this.partitionCoordinator = partitionCoordinator;
        }

        public static Builder of(String nakadiUrl, String eventName, PartitionCoordinator coordinator) {
            return new Builder(nakadiUrl, eventName, coordinator);
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder withAuthorization(AuthorizationValueProvider authorizationValueProvider) {
            this.authorizationValueProvider = authorizationValueProvider;
            return this;
        }

        public Builder withEventsTimeoutMillis(long eventsTimeoutMillis) {
            this.eventsTimeoutMillis = eventsTimeoutMillis;
            return this;
        }

        public Builder withEventsRetryAfterMillis(long eventsRetryAfterMillis) {
            this.eventsRetryAfterMillis = eventsRetryAfterMillis;
            return this;
        }

        public Builder withEventsRetryRandomMillis(long eventsRetryRandomMillis) {
            this.eventsRetryRandomMillis = eventsRetryRandomMillis;
            return this;
        }

        public Builder withEventStreamConfig(EventStreamConfig eventStreamConfig) {
            this.eventStreamConfig = eventStreamConfig;
            return this;
        }

        public Builder withPartitionsTimeoutMillis(long partitionsTimeoutMillis) {
            this.partitionsTimeoutMillis = partitionsTimeoutMillis;
            return this;
        }

        public Builder withPartitionsRetryAfterMillis(long partitionsRetryAfterMillis) {
            this.partitionsRetryAfterMillis = partitionsRetryAfterMillis;
            return this;
        }

        public Builder withPartitionsRetryRandomMillis(long partitionsRetryRandomMillis) {
            this.partitionsRetryRandomMillis = partitionsRetryRandomMillis;
            return this;
        }

        public Builder withResponseHandlerFactory(ResponseHandlerFactory responseHandlerFactory) {
            Preconditions.checkState((boolean)Objects.isNull(this.responseHandlerFactory), (Object)"responseHandlerFactory is already initialized");
            this.responseHandlerFactory = responseHandlerFactory;
            return this;
        }

        public <T> Builder withBatchEventsHandler(BatchEventsHandler<T> handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new BatchEventsResponseHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public <T> Builder withBatchEventsBulkHandler(BatchEventsBulkHandler<T> handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new BatchEventsResponseBulkHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public Builder withRawContentHandler(RawContentHandler handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new RawContentResponseHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public Builder withRawEventHandler(RawEventHandler handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new RawEventResponseHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public Builder withRawEventBulkHandler(RawEventBulkHandler handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new RawEventResponseBulkHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public Builder withJsonEventHandler(JsonEventHandler handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new JsonEventResponseHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public Builder withJsonEventBulkHandler(JsonEventBulkHandler handler) {
            return this.withResponseHandlerFactory((eventTypePartition, jsonMapper) -> new JsonEventResponseBulkHandler(eventTypePartition, jsonMapper, this.partitionCoordinator, handler));
        }

        public static ObjectMapper defaultObjectMapper() {
            return new DefaultObjectMapper().jacksonObjectMapper();
        }

        public ConsumerConfig build() {
            return new ConsumerConfig(this);
        }
    }
}

