/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NakadiPartition {
    private final String partition;
    private final String oldestAvailableOffset;
    private final String newestAvailableOffset;
    private final Long unconsumedEvents;

    @JsonCreator
    public NakadiPartition(@JsonProperty(value="partition") String partition, @JsonProperty(value="oldest_available_offset") String oldestAvailableOffset, @JsonProperty(value="newest_available_offset") String newestAvailableOffset, @Nullable @JsonProperty(value="unconsumed_events") Long unconsumedEvents) {
        this.partition = partition;
        this.oldestAvailableOffset = oldestAvailableOffset;
        this.newestAvailableOffset = newestAvailableOffset;
        this.unconsumedEvents = unconsumedEvents;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getOldestAvailableOffset() {
        return this.oldestAvailableOffset;
    }

    public String getNewestAvailableOffset() {
        return this.newestAvailableOffset;
    }

    public Optional<Long> getUnconsumedEvents() {
        return Optional.ofNullable(this.unconsumedEvents);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", (Object)this.partition).add("oldestAvailableOffset", (Object)this.oldestAvailableOffset).add("newestAvailableOffset", (Object)this.newestAvailableOffset).add("unconsumedEvents", (Object)this.unconsumedEvents).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NakadiPartition that = (NakadiPartition)o;
        return Objects.equal((Object)this.partition, (Object)that.partition) && Objects.equal((Object)this.oldestAvailableOffset, (Object)that.oldestAvailableOffset) && Objects.equal((Object)this.newestAvailableOffset, (Object)that.newestAvailableOffset) && Objects.equal((Object)this.unconsumedEvents, (Object)that.unconsumedEvents);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partition, this.oldestAvailableOffset, this.newestAvailableOffset, this.unconsumedEvents});
    }
}

