/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.AbstractEventsResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.BatchEventsHandler;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.EventClassProvider;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.ThrowableUtils;
import java.io.IOException;

public class BatchEventsResponseHandler<T>
extends AbstractEventsResponseHandler<T> {
    private final JavaType javaType;

    public BatchEventsResponseHandler(EventTypePartition eventTypePartition, ObjectMapper jsonMapper, PartitionCoordinator coordinator, BatchEventsHandler<T> delegate) {
        super(eventTypePartition, coordinator, BatchEventsResponseHandler.class, jsonMapper, delegate);
        this.javaType = EventClassProvider.getJavaType(delegate, jsonMapper);
    }

    @Override
    NakadiEventBatch<T> getEventBatch(String string) {
        try {
            return (NakadiEventBatch)this.jsonMapper.readValue(string, this.javaType);
        }
        catch (IOException e) {
            ThrowableUtils.throwException(e);
            return null;
        }
    }
}

