/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.EventHandler;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.AbstractResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.LoggingUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractEventsResponseHandler<T>
extends AbstractResponseHandler {
    private final EventHandler<T> delegate;

    AbstractEventsResponseHandler(String consumerName, EventTypePartition eventTypePartition, PartitionCoordinator coordinator, Class<?> loggerClazz, ObjectMapper jsonMapper, EventHandler<T> delegate) {
        super(consumerName, eventTypePartition, coordinator, LoggingUtils.getLogger(loggerClazz, eventTypePartition), jsonMapper);
        this.delegate = delegate;
    }

    @Override
    public void onResponse(String content) {
        String[] events;
        for (String event : events = this.getEvents(content)) {
            NakadiEventBatch<T> nakadiEventBatch = Objects.requireNonNull(this.getNakadiEventBatch(event), "Nakadi event batch must not be null!");
            EventTypeCursor cursor = EventTypeCursor.of(this.eventTypePartition, nakadiEventBatch.getCursor().getOffset());
            List<T> batchEvents = nakadiEventBatch.getEvents();
            if (batchEvents == null || batchEvents.isEmpty()) {
                this.log.info("Keep alive offset [{}]", (Object)cursor.getOffset());
                continue;
            }
            this.handleEvents(cursor, batchEvents, content);
        }
    }

    @Nullable
    private NakadiEventBatch<T> getNakadiEventBatch(String event) {
        try {
            return this.getEventBatch(event);
        }
        catch (Throwable t) {
            this.coordinator.error(this.consumerName, t, this.eventTypePartition, null, event);
            return null;
        }
    }

    private void handleEvents(EventTypeCursor cursor, List<T> events, String content) {
        for (T event : events) {
            try {
                this.delegate.onEvent(cursor, event);
            }
            catch (Throwable t) {
                this.log.error("Handler error at cursor [{}]", (Object)cursor);
                this.coordinator.error(this.consumerName, t, this.eventTypePartition, cursor.getOffset(), content);
            }
        }
        this.coordinator.commit(cursor);
    }

    abstract NakadiEventBatch<T> getEventBatch(String var1);
}

