/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.utils;

import com.google.common.base.Throwables;
import de.zalando.paradox.nakadi.consumer.core.exceptions.UnrecoverableException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.http.conn.ConnectTimeoutException;

public class ThrowableUtils {
    private static final Predicate<Throwable> UNRECOVERABLE_EXCEPTION_PREDICATE = t -> t instanceof UnrecoverableException;
    private static final Predicate<Throwable> ERROR_PREDICATE = t -> t instanceof Error;
    private static final Predicate<Throwable> UNRECOVERABLE_PREDICATE = UNRECOVERABLE_EXCEPTION_PREDICATE.or(ERROR_PREDICATE);
    private static final Predicate<Throwable> SOCKET_TIMEOUT_EXCEPTION_PREDICATE = t -> t instanceof SocketTimeoutException;
    private static final Predicate<Throwable> CONCURRENT_TIMEOUT_EXCEPTION_PREDICATE = t -> t instanceof TimeoutException;
    private static final Predicate<Throwable> HTTP_CONNECT_TIMEOUT_EXCEPTION_PREDICATE = t -> t instanceof ConnectTimeoutException;
    private static final Predicate<Throwable> TIMEOUT_PREDICATE = SOCKET_TIMEOUT_EXCEPTION_PREDICATE.or(CONCURRENT_TIMEOUT_EXCEPTION_PREDICATE).or(HTTP_CONNECT_TIMEOUT_EXCEPTION_PREDICATE);

    private ThrowableUtils() {
    }

    public static void throwException(Throwable t) {
        ThrowableUtils.throwException0(t);
    }

    private static <E extends Throwable> void throwException0(Throwable t) throws E {
        throw t;
    }

    public static boolean isUnrecoverableException(Throwable exception) {
        return ThrowableUtils.isException(exception, UNRECOVERABLE_PREDICATE);
    }

    public static boolean isTimeoutException(Throwable exception) {
        return ThrowableUtils.isException(exception, TIMEOUT_PREDICATE);
    }

    private static boolean isException(Throwable exception, Predicate<Throwable> predicate) {
        return Throwables.getCausalChain((Throwable)exception).stream().filter(predicate).findFirst().isPresent();
    }
}

