/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.requests;

import de.zalando.paradox.nakadi.consumer.core.ConsumerConfig;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.http.HttpReactiveHandler;
import de.zalando.paradox.nakadi.consumer.core.http.HttpResponseChunk;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.ResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.http.okhttp.RxHttpRequest;
import de.zalando.paradox.nakadi.consumer.core.http.requests.HttpGetEvents;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCommitCallback;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.LoggingUtils;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import rx.Observable;

public class HttpGetEventsHandler
implements HttpReactiveHandler,
PartitionCommitCallback {
    private final Logger log;
    private final ConsumerConfig config;
    private final EventTypeCursor startCursor;
    private HttpGetEvents httpGetEvents;
    private PartitionCoordinator coordinator;
    private ResponseHandler responseHandler;
    private final AtomicBoolean callbackRegistered = new AtomicBoolean(false);

    public HttpGetEventsHandler(String baseUri, EventTypeCursor startCursor, ConsumerConfig config) {
        this.log = LoggingUtils.getLogger(this.getClass(), startCursor.getEventTypePartition());
        this.startCursor = startCursor;
        this.config = config;
        this.httpGetEvents = new HttpGetEvents(baseUri, startCursor, config.getEventStreamConfig());
        this.coordinator = config.getPartitionCoordinator();
        this.responseHandler = config.getResponseHandlerFactory().get(startCursor.getEventTypePartition(), config.getObjectMapper());
    }

    @Override
    public Logger getLogger(Class<?> clazz) {
        return LoggingUtils.getLogger(this.getClass(), "events", this.startCursor.getEventTypePartition());
    }

    @Override
    public void onResponse(String content) {
        this.log.trace("ResultCallback : [{}]", (Object)content);
        this.responseHandler.onResponse(content);
    }

    @Override
    public void onErrorResponse(int statusCode, String content) {
        this.log.trace("Error result [{} / {}]", (Object)statusCode, (Object)content);
        this.coordinator.error(statusCode, content, this.startCursor.getEventTypePartition());
    }

    @Override
    public void onStarted() {
        this.log.trace("Started");
    }

    @Override
    public void onFinished() {
        this.log.trace("Finished");
        try {
            this.coordinator.flush(this.startCursor.getEventTypePartition());
        }
        finally {
            this.coordinator.finished(this.startCursor.getEventTypePartition());
        }
    }

    @Override
    public void init() {
        if (this.callbackRegistered.compareAndSet(false, true)) {
            this.coordinator.registerCommitCallback(this.startCursor.getEventTypePartition(), this);
        }
    }

    @Override
    public void close() {
        if (this.callbackRegistered.compareAndSet(true, false)) {
            this.coordinator.unregisterCommitCallback(this.startCursor.getEventTypePartition());
        }
    }

    @Override
    public long getRetryAfterMillis() {
        if (this.config.getEventsRetryRandomMillis() > 0L) {
            return this.config.getEventsRetryAfterMillis() + ThreadLocalRandom.current().nextLong(this.config.getEventsRetryRandomMillis());
        }
        return this.config.getEventsRetryAfterMillis();
    }

    @Override
    public Observable<HttpResponseChunk> createRequest() {
        return new RxHttpRequest(this.config.getEventsTimeoutMillis(), this.config.getAuthorizationValueProvider()).createRequest(this.httpGetEvents);
    }

    @Override
    public void onCommitComplete(EventTypeCursor cursor) {
        this.log.trace("onCommitComplete");
        this.httpGetEvents.setOffset(cursor.getOffset());
    }
}

