/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.core.domain.EventType;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventCursor;
import de.zalando.paradox.nakadi.consumer.core.http.handlers.ResponseHandler;
import de.zalando.paradox.nakadi.consumer.core.partitioned.PartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.core.utils.ThrowableUtils;
import java.io.IOException;
import org.slf4j.Logger;

abstract class AbstractResponseHandler
implements ResponseHandler {
    private static final String BATCH_SEPARATOR = "\n";
    protected final Logger log;
    protected final ObjectMapper jsonMapper;
    protected final EventTypePartition eventTypePartition;
    protected final PartitionCoordinator coordinator;
    protected final String consumerName;
    protected final EventType eventType;

    AbstractResponseHandler(String consumerName, EventTypePartition eventTypePartition, PartitionCoordinator coordinator, Logger log, ObjectMapper jsonMapper) {
        this.eventTypePartition = eventTypePartition;
        this.coordinator = coordinator;
        this.log = log;
        this.jsonMapper = jsonMapper;
        this.consumerName = consumerName;
        this.eventType = eventTypePartition.getEventType();
    }

    String[] getEvents(String string) {
        return string.split(BATCH_SEPARATOR);
    }

    NakadiEventCursor getEventCursor(String string) {
        try {
            return (NakadiEventCursor)this.jsonMapper.readValue(string, NakadiEventCursor.class);
        }
        catch (IOException e) {
            this.log.error("Error while parsing event cursor from [{}]", (Object)string, (Object)e);
            ThrowableUtils.throwException(e);
            return null;
        }
    }
}

