/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.core.http.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import de.zalando.paradox.nakadi.consumer.core.domain.EventType;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.NakadiEventBatch;
import de.zalando.paradox.nakadi.consumer.core.exceptions.InvalidEventTypeException;
import de.zalando.paradox.nakadi.consumer.core.utils.ThrowableUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventUtils.class);

    private EventUtils() {
    }

    public static NakadiEventBatch<String> getRawEventBatch(ObjectMapper jsonMapper, String string, EventType eventType) {
        try {
            List rawEvents;
            EventReader reader = new EventReader(jsonMapper, string).invoke();
            JsonNode eventsNode = reader.getEventsNode();
            if (null != eventsNode && eventsNode.isArray() && eventsNode.size() > 0) {
                rawEvents = new ArrayList(eventsNode.size());
                ArrayNode arrayNode = (ArrayNode)eventsNode;
                arrayNode.elements().forEachRemaining(element -> {
                    String rawEvent = null;
                    try {
                        EventUtils.checkEventType(element, eventType);
                        rawEvent = jsonMapper.writeValueAsString(element);
                    }
                    catch (JsonProcessingException e) {
                        ThrowableUtils.throwException(e);
                    }
                    if (StringUtils.isNotEmpty(rawEvent)) {
                        rawEvents.add(rawEvent);
                    }
                });
            } else {
                rawEvents = Collections.emptyList();
            }
            return new NakadiEventBatch<String>(new NakadiCursor(reader.getPartition(), reader.getOffset()), rawEvents);
        }
        catch (IOException e) {
            LOGGER.error("Error while parsing event batch from [{}]", (Object)string, (Object)e);
            ThrowableUtils.throwException(e);
            return null;
        }
    }

    public static NakadiEventBatch<JsonNode> getJsonEventBatch(ObjectMapper jsonMapper, String string, EventType eventType) {
        try {
            List jsonEvents;
            EventReader reader = new EventReader(jsonMapper, string).invoke();
            JsonNode eventsNode = reader.getEventsNode();
            if (null != eventsNode && eventsNode.isArray() && eventsNode.size() > 0) {
                jsonEvents = new ArrayList(eventsNode.size());
                ArrayNode arrayNode = (ArrayNode)eventsNode;
                arrayNode.elements().forEachRemaining(element -> {
                    EventUtils.checkEventType(element, eventType);
                    jsonEvents.add(element);
                });
            } else {
                jsonEvents = Collections.emptyList();
            }
            return new NakadiEventBatch<JsonNode>(new NakadiCursor(reader.getPartition(), reader.getOffset()), jsonEvents);
        }
        catch (IOException e) {
            LOGGER.error("Error while parsing event json from [{}]", (Object)string, (Object)e);
            ThrowableUtils.throwException(e);
            return null;
        }
    }

    private static void checkEventType(JsonNode element, EventType eventType) {
        if (!element.isNull() && element.has("metadata") && element.get("metadata").has("event_type") && !element.get("metadata").get("event_type").asText().equals(eventType.getName())) {
            throw new InvalidEventTypeException(String.format("Unexpected event type (expected=[%s], actual=[%s])", eventType.getName(), element.get("metadata").get("event_type").asText()));
        }
    }

    private static class EventReader {
        private ObjectMapper jsonMapper;
        private String string;
        private String partition;
        private String offset;
        private JsonNode eventsNode;

        EventReader(ObjectMapper jsonMapper, String string) {
            this.jsonMapper = jsonMapper;
            this.string = string;
        }

        String getPartition() {
            return this.partition;
        }

        String getOffset() {
            return this.offset;
        }

        JsonNode getEventsNode() {
            return this.eventsNode;
        }

        EventReader invoke() throws IOException {
            JsonNode node = this.jsonMapper.readTree(this.string);
            JsonNode cursorNode = Objects.requireNonNull(node.get("cursor"), "cursor node must not be null");
            this.partition = cursorNode.get("partition").textValue();
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.partition), (Object)"cursor.partition must not be empty");
            this.offset = cursorNode.get("offset").textValue();
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.offset), (Object)"cursor.offset must not be empty");
            this.eventsNode = node.get("events");
            return this;
        }
    }
}

