/**
 * Copyright (C) 2015 Zalando SE (team-phrasers+oss@zalando.de)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zalando.jersey.gson;

import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;

import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.InternalProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;

import org.zalando.jersey.gson.internal.GsonJsonProvider;

/**
 * Feature used to register GSON JSON providers.
 *
 * @author <a href="mailto:christoph.berg@zalando.de"> Christoph Berg </a>
 */
public class GsonFeature implements Feature {
    public static final String JSON_FEATURE = GsonFeature.class.getSimpleName();

    @Override
    public boolean configure(final FeatureContext context) {
        final Configuration config = context.getConfiguration();

        final String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(),
                InternalProperties.JSON_FEATURE, JSON_FEATURE, String.class);

        // Other JSON providers registered
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }

        // Disable other JSON providers
        context.property(PropertiesHelper.getPropertyNameForRuntime(InternalProperties.JSON_FEATURE,
                config.getRuntimeType()), JSON_FEATURE);

        // Register GSON
        if (!config.isRegistered(GsonJsonProvider.class)) {
            context.register(GsonJsonProvider.class);
        }

        return true;
    }
}
