/**
 * Copyright (C) 2015 Zalando SE (team-phrasers+oss@zalando.de)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zalando.jersey.gson.internal;

import javax.ws.rs.core.FeatureContext;

import org.glassfish.jersey.internal.spi.AutoDiscoverable;

import org.zalando.jersey.gson.GsonFeature;

/**
 * {@link AutoDiscoverable} registering {@link GsonFeature} if it is not already registered.
 *
 * @author <a href="mailto:christoph.berg@zalando.de"> Christoph Berg </a>
 */
public class GsonAutoDiscoverable implements AutoDiscoverable {

    @Override
    public void configure(final FeatureContext context) {
        if (!context.getConfiguration().isRegistered(GsonFeature.class)) {
            context.register(GsonFeature.class);
        }
    }
}
