/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.jersey.gson.internal;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.zalando.jersey.gson.GsonProvider;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GsonJsonProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    @Context
    private Providers providers;
    private Gson gson;
    private Charset charset = StandardCharsets.UTF_8;

    private Gson getGson() {
        if (this.gson != null) {
            return this.gson;
        }
        ContextResolver contextResolver = this.providers.getContextResolver(Gson.class, MediaType.APPLICATION_JSON_TYPE);
        if (contextResolver != null) {
            this.gson = (Gson)contextResolver.getContext(Gson.class);
        } else {
            Iterator<GsonProvider> providers = ServiceLoader.load(GsonProvider.class).iterator();
            if (providers.hasNext()) {
                this.gson = (Gson)providers.next().get();
            }
        }
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        Type jsonType = type.equals(genericType) ? type : genericType;
        try (InputStreamReader reader = new InputStreamReader(entityStream, this.charset);){
            Object object = this.getGson().fromJson((Reader)reader, jsonType);
            return object;
        }
        catch (JsonSyntaxException e) {
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Type jsonType = type.equals(genericType) ? type : genericType;
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, this.charset);){
            this.getGson().toJson(object, jsonType, (Appendable)writer);
        }
    }
}

