/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.FactoryBean;
import org.zalando.putittorest.GlobalOAuth;
import org.zalando.putittorest.OAuth;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.Timeouts;
import org.zalando.stups.tokens.AccessTokens;
import org.zalando.stups.tokens.AccessTokensBuilder;
import org.zalando.stups.tokens.Tokens;

class AccessTokensFactoryBean
implements FactoryBean<AccessTokens> {
    private AccessTokensBuilder builder;

    AccessTokensFactoryBean() {
    }

    public void setSettings(RestSettings settings) {
        GlobalOAuth oauth = settings.getOauth();
        Timeouts timeouts = oauth.getTimeouts();
        URI accessTokenUrl = this.getAccessTokenUrl(oauth);
        this.builder = Tokens.createAccessTokensWithUri((URI)accessTokenUrl).schedulingPeriod(oauth.getSchedulingPeriod()).connectTimeout(Timeouts.toMillis(timeouts.getConnect())).socketTimeout(Timeouts.toMillis(timeouts.getRead()));
        settings.getClients().forEach((id, client) -> this.builder.manageToken(id).addScopes((Collection)Optional.ofNullable(client.getOauth()).map(OAuth::getScopes).orElse(Collections.emptyList())).done());
    }

    private URI getAccessTokenUrl(GlobalOAuth oauth) {
        URI accessTokenUrl = oauth.getAccessTokenUrl();
        if (accessTokenUrl == null) {
            return URI.create(System.getenv("ACCESS_TOKEN_URL"));
        }
        return accessTokenUrl;
    }

    public AccessTokens getObject() {
        return this.builder.start();
    }

    public Class<?> getObjectType() {
        return AccessTokens.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

