/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.google.common.base.CaseFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.zalando.putittorest.annotation.RestClient;

final class Registry {
    private static final Logger LOG = LoggerFactory.getLogger(Registry.class);
    private final BeanDefinitionRegistry registry;

    Registry(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public boolean isRegistered(String name) {
        return this.registry.isBeanNameInUse(name);
    }

    public <T> String register(Class<T> type, Supplier<BeanDefinitionBuilder> factory) {
        String name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, type.getSimpleName());
        if (this.isRegistered(name)) {
            LOG.debug("Bean [{}] is already registered, skipping it.", (Object)name);
            return name;
        }
        this.registry.registerBeanDefinition(name, (BeanDefinition)factory.get().getBeanDefinition());
        return name;
    }

    public <T> String register(String id, Class<T> type, Supplier<BeanDefinitionBuilder> factory) {
        String name = Registry.generateBeanName(id, type);
        if (this.isRegistered(name)) {
            LOG.debug("Bean [{}] is already registered, skipping it.", (Object)name);
            return name;
        }
        AbstractBeanDefinition definition = factory.get().getBeanDefinition();
        definition.addQualifier(new AutowireCandidateQualifier(RestClient.class, (Object)id));
        definition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)id));
        this.registry.registerBeanDefinition(name, (BeanDefinition)definition);
        return name;
    }

    public static <T> String generateBeanName(String id, Class<T> type) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, id) + type.getSimpleName();
    }

    public static BeanReference ref(String beanName) {
        return new RuntimeBeanReference(beanName);
    }

    public static List<Object> list(Object ... elements) {
        ManagedList list = new ManagedList();
        Collections.addAll(list, elements);
        return list;
    }
}

