/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.FactoryBean;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.TimeSpan;
import org.zalando.stups.tokens.AccessTokens;
import org.zalando.stups.tokens.AccessTokensBuilder;
import org.zalando.stups.tokens.Tokens;

class AccessTokensFactoryBean
implements FactoryBean<AccessTokens> {
    private AccessTokensBuilder builder;

    AccessTokensFactoryBean() {
    }

    public void setSettings(RestSettings settings) {
        RestSettings.Defaults defaults = settings.getDefaults();
        RestSettings.GlobalOAuth oAuth = settings.getOauth();
        URI accessTokenUrl = this.getAccessTokenUrl(oAuth);
        TimeSpan connectionTimeout = (TimeSpan)MoreObjects.firstNonNull((Object)oAuth.getConnectionTimeout(), (Object)defaults.getConnectionTimeout());
        TimeSpan socketTimeout = (TimeSpan)MoreObjects.firstNonNull((Object)oAuth.getSocketTimeout(), (Object)defaults.getSocketTimeout());
        this.builder = Tokens.createAccessTokensWithUri((URI)accessTokenUrl).schedulingPeriod((int)oAuth.getSchedulingPeriod().getAmount()).schedulingTimeUnit(oAuth.getSchedulingPeriod().getUnit()).connectTimeout((int)connectionTimeout.to(TimeUnit.MILLISECONDS)).socketTimeout((int)socketTimeout.to(TimeUnit.MILLISECONDS));
        settings.getClients().forEach((id, client) -> {
            RestSettings.OAuth clientOAuth = client.getOauth();
            if (clientOAuth == null) {
                return;
            }
            this.builder.manageToken(id).addScopes(clientOAuth.getScopes()).done();
        });
    }

    private URI getAccessTokenUrl(RestSettings.GlobalOAuth oauth) {
        URI accessTokenUrl = oauth.getAccessTokenUrl();
        if (accessTokenUrl == null) {
            String env = System.getenv("ACCESS_TOKEN_URL");
            Preconditions.checkArgument((env != null ? 1 : 0) != 0, (Object)"Neither 'rest.oauth.access-token-url' nor 'ACCESS_TOKEN_URL' was set, but at least one client requires OAuth");
            return URI.create(env);
        }
        return accessTokenUrl;
    }

    public AccessTokens getObject() {
        return this.builder.start();
    }

    public Class<?> getObjectType() {
        return AccessTokens.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

