/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.stereotype.Component;
import org.zalando.putittorest.HttpClientCustomizer;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.TimeSpan;

@Component
class HttpClientFactoryBean
implements FactoryBean<HttpClient> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactoryBean.class);
    private final HttpClientBuilder builder = HttpClientBuilder.create();
    private final RequestConfig.Builder config = RequestConfig.custom();
    private HttpClientCustomizer customizer = $ -> {};

    HttpClientFactoryBean() {
    }

    public void setFirstRequestInterceptors(List<HttpRequestInterceptor> interceptors) {
        interceptors.forEach(arg_0 -> ((HttpClientBuilder)this.builder).addInterceptorFirst(arg_0));
    }

    public void setLastRequestInterceptors(List<HttpRequestInterceptor> interceptors) {
        interceptors.forEach(arg_0 -> ((HttpClientBuilder)this.builder).addInterceptorLast(arg_0));
    }

    public void setLastResponseInterceptors(List<HttpResponseInterceptor> interceptors) {
        interceptors.forEach(arg_0 -> ((HttpClientBuilder)this.builder).addInterceptorLast(arg_0));
    }

    public void setConnectionTimeout(TimeSpan connectTimeout) {
        this.config.setConnectTimeout((int)connectTimeout.to(TimeUnit.MILLISECONDS));
    }

    public void setSocketTimeout(TimeSpan socketTimeout) {
        this.config.setSocketTimeout((int)socketTimeout.to(TimeUnit.MILLISECONDS));
    }

    public void setConnectionTimeToLive(TimeSpan timeToLive) {
        this.builder.setConnectionTimeToLive(timeToLive.getAmount(), timeToLive.getUnit());
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.builder.setMaxConnPerRoute(maxConnectionsPerRoute);
    }

    public void setMaxConnectionsTotal(int maxConnectionsTotal) {
        this.builder.setMaxConnTotal(maxConnectionsTotal);
    }

    public void setTrustedKeystore(RestSettings.Keystore keystore) throws Exception {
        SSLContextBuilder ssl = SSLContexts.custom();
        String path = keystore.getPath();
        String password = keystore.getPassword();
        URL resource = HttpClientFactoryBean.class.getClassLoader().getResource(path);
        if (resource == null) {
            throw new FileNotFoundException(String.format("Keystore [%s] not found.", path));
        }
        try {
            ssl.loadTrustMaterial(resource, password == null ? null : password.toCharArray());
            this.builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(ssl.build(), SSLConnectionSocketFactory.getDefaultHostnameVerifier()));
        }
        catch (Exception e) {
            LOG.error("Error loading keystore [{}]:", (Object)path, (Object)e);
            throw e;
        }
    }

    public void setCustomizer(HttpClientCustomizer customizer) {
        this.customizer = customizer;
    }

    public CloseableHttpClient getObject() {
        this.builder.setDefaultRequestConfig(this.config.build());
        this.customizer.customize(this.builder);
        return this.builder.build();
    }

    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

