/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest.zmon;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.zalando.putittorest.zmon.Timing;
import org.zalando.zmon.actuator.metrics.MetricsWrapper;

public class ZmonResponseInterceptor
implements HttpResponseInterceptor {
    private final MetricsWrapper metricsWrapper;

    public ZmonResponseInterceptor(MetricsWrapper metricsWrapper) {
        this.metricsWrapper = metricsWrapper;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        long endTime = System.currentTimeMillis();
        Timing timing = (Timing)context.getAttribute(Timing.ATTRIBUTE);
        if (timing != null) {
            this.metricsWrapper.recordBackendRoundTripMetrics(timing.getMethod(), timing.getHost(), this.getStatusCode(response), endTime - timing.getStartTime());
        }
    }

    private int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }
}

