/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.gag.annotation.remark.Hack;
import com.google.gag.annotation.remark.OhNoYouDidnt;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.ClassUtils;
import org.zalando.fauxpas.FauxPas;
import org.zalando.putittorest.DeferredPlugin;
import org.zalando.putittorest.PluginResolver;
import org.zalando.riptide.OriginalStackTracePlugin;
import org.zalando.riptide.Plugin;

public final class DefaultPluginResolver
implements PluginResolver {
    private final ImmutableMap<String, Optional<Plugin>> plugins;

    public DefaultPluginResolver(ListableBeanFactory factory) {
        this.plugins = ImmutableMap.of((Object)"original-stack-trace", Optional.of(new OriginalStackTracePlugin()), (Object)"temporary-exception", DefaultPluginResolver.defer(factory, "org.zalando.riptide.exceptions.TemporaryExceptionPlugin"), (Object)"hystrix", DefaultPluginResolver.defer(factory, "org.zalando.riptide.hystrix.HystrixPlugin"));
    }

    @Hack
    @OhNoYouDidnt
    private static Optional<Plugin> defer(ListableBeanFactory factory, String typeName) {
        return Optional.of(typeName).filter(DefaultPluginResolver::exists).map(FauxPas.throwingFunction(DefaultPluginResolver::forName)).map(type -> DefaultPluginResolver.defer(factory, type));
    }

    private static boolean exists(String name) {
        return ClassUtils.isPresent((String)name, (ClassLoader)ClassUtils.getDefaultClassLoader());
    }

    private static Class<? extends Plugin> forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName((String)name, (ClassLoader)ClassUtils.getDefaultClassLoader()).asSubclass(Plugin.class);
    }

    private static DeferredPlugin defer(ListableBeanFactory factory, Class<? extends Plugin> type) {
        return new DeferredPlugin(type, (Supplier<? extends Plugin>)FauxPas.throwingSupplier(() -> {
            if (factory.getBeanNamesForType(type).length > 0) {
                return (Plugin)factory.getBean(type);
            }
            Constructor constructor = type.getConstructor(new Class[0]);
            return (Plugin)Invokable.from(constructor).invoke(null, new Object[0]);
        }));
    }

    @Override
    public Plugin resolve(String name) {
        return (Plugin)((Optional)this.plugins.getOrDefault((Object)name, Optional.empty())).orElseThrow(() -> new IllegalArgumentException("Unknown plugin name: " + name));
    }
}

