/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.protocol.HttpContext;

class GzippingHttpRequestInterceptor
implements HttpRequestInterceptor {
    GzippingHttpRequestInterceptor() {
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity()) != null) {
            GzipCompressingEntity zippedEntity = new GzipCompressingEntity(entity);
            entityRequest.setEntity((HttpEntity)zippedEntity);
            request.removeHeaders("Content-Encoding");
            request.addHeader(zippedEntity.getContentEncoding());
            request.removeHeaders("Content-Length");
            request.removeHeaders("Transfer-Encoding");
            request.addHeader("Transfer-Encoding", "chunked");
        }
    }
}

