/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.zalando.putittorest.AccessTokensFactoryBean;
import org.zalando.putittorest.ClientHttpMessageConverters;
import org.zalando.putittorest.GzippingHttpRequestInterceptor;
import org.zalando.putittorest.HttpClientCustomizer;
import org.zalando.putittorest.HttpClientFactoryBean;
import org.zalando.putittorest.PluginResolver;
import org.zalando.putittorest.Plugins;
import org.zalando.putittorest.Registry;
import org.zalando.putittorest.RestFactory;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.zmon.ZmonRequestInterceptor;
import org.zalando.putittorest.zmon.ZmonResponseInterceptor;
import org.zalando.riptide.Rest;
import org.zalando.riptide.httpclient.RestAsyncClientHttpRequestFactory;
import org.zalando.riptide.stream.Streams;
import org.zalando.stups.oauth2.httpcomponents.AccessTokensRequestInterceptor;
import org.zalando.stups.tokens.AccessTokens;
import org.zalando.tracer.concurrent.TracingExecutors;

public class RestClientPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientPostProcessor.class);
    private final ObjectFactory<PluginResolver> resolver;
    private ConfigurableEnvironment environment;
    private Registry registry;
    private RestSettings settings;

    public RestClientPostProcessor(ObjectFactory<PluginResolver> resolver) {
        this.resolver = resolver;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.registry = new Registry(beanDefinitionRegistry);
        RestSettings settings = this.getSettings();
        RestSettings.Defaults defaults = settings.getDefaults();
        settings.getClients().forEach((id, client) -> {
            String factoryId = this.registerAsyncClientHttpRequestFactory((String)id, defaults, (RestSettings.Client)client);
            String convertersId = this.registerHttpMessageConverters((String)id);
            String baseUrl = client.getBaseUrl();
            this.registerRest((String)id, (RestSettings.Client)client, factoryId, convertersId, baseUrl);
            this.registerRestTemplate((String)id, factoryId, convertersId, baseUrl);
            this.registerAsyncRestTemplate((String)id, factoryId, convertersId, baseUrl);
        });
    }

    @VisibleForTesting
    RestSettings getSettings() {
        if (this.settings == null) {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(RestSettings.class);
            factory.setTargetName("rest");
            factory.setPropertySources((PropertySources)this.environment.getPropertySources());
            factory.setConversionService((ConversionService)this.environment.getConversionService());
            this.settings = (RestSettings)factory.getObject();
        }
        return this.settings;
    }

    private String registerHttpMessageConverters(String id) {
        return this.registry.register(id, HttpMessageConverters.class, () -> {
            List<Object> list = Registry.list(new Object[0]);
            LOG.debug("Client [{}]: Registering StringHttpMessageConverter", (Object)id);
            list.add(BeanDefinitionBuilder.genericBeanDefinition(StringHttpMessageConverter.class).addPropertyValue("writeAcceptCharset", (Object)false).getBeanDefinition());
            String objectMapperId = this.findObjectMapper(id);
            LOG.debug("Client [{}]: Registering MappingJackson2HttpMessageConverter referencing [{}]", (Object)id, (Object)objectMapperId);
            list.add(BeanDefinitionBuilder.genericBeanDefinition(MappingJackson2HttpMessageConverter.class).addConstructorArgReference(objectMapperId).getBeanDefinition());
            LOG.debug("Client [{}]: Registering StreamConverter referencing [{}]", (Object)id, (Object)objectMapperId);
            list.add(BeanDefinitionBuilder.genericBeanDefinition(Streams.class).setFactoryMethod("streamConverter").addConstructorArgReference(objectMapperId).getBeanDefinition());
            return BeanDefinitionBuilder.genericBeanDefinition(ClientHttpMessageConverters.class).addConstructorArgValue(list);
        });
    }

    private String findObjectMapper(String id) {
        String beanName = Registry.generateBeanName(id, ObjectMapper.class);
        return this.registry.isRegistered(beanName) ? beanName : "jacksonObjectMapper";
    }

    private String registerAccessTokens(String id, RestSettings settings) {
        return this.registry.register(AccessTokens.class, () -> {
            LOG.debug("Client [{}]: Registering AccessTokens", (Object)id);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AccessTokensFactoryBean.class);
            builder.addPropertyValue("settings", (Object)settings);
            return builder;
        });
    }

    private String registerRest(String id, RestSettings.Client client, String factoryId, String convertersId, @Nullable String baseUrl) {
        return this.registry.register(id, Rest.class, () -> {
            LOG.debug("Client [{}]: Registering Rest", (Object)id);
            BeanDefinitionBuilder rest = BeanDefinitionBuilder.genericBeanDefinition(RestFactory.class);
            rest.setFactoryMethod("create");
            rest.addConstructorArgReference(factoryId);
            AbstractBeanDefinition converters = BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethod("getConverters").getBeanDefinition();
            converters.setFactoryBeanName(convertersId);
            rest.addConstructorArgValue((Object)converters);
            rest.addConstructorArgValue((Object)baseUrl);
            rest.addConstructorArgReference(this.registerPlugins(id, client.getPlugins()));
            return rest;
        });
    }

    private String registerPlugins(String id, List<String> clientPlugins) {
        return this.registry.register(id, Plugins.class, () -> {
            List<Object> defaultPlugins = this.settings.getDefaults().getPlugins().isEmpty() ? RestSettings.Defaults.PLUGINS : this.settings.getDefaults().getPlugins();
            List<Object> names = clientPlugins.isEmpty() ? defaultPlugins : clientPlugins;
            BeanDefinitionBuilder plugins = BeanDefinitionBuilder.genericBeanDefinition(Plugins.class);
            plugins.addConstructorArgValue(() -> names.stream().map(name -> ((PluginResolver)this.resolver.getObject()).resolve((String)name)).collect(Collectors.toList()));
            return plugins;
        });
    }

    private String registerRestTemplate(String id, String factoryId, String convertersId, @Nullable String baseUrl) {
        return this.registry.register(id, RestTemplate.class, () -> {
            LOG.debug("Client [{}]: Registering RestTemplate", (Object)id);
            BeanDefinitionBuilder restTemplate = BeanDefinitionBuilder.genericBeanDefinition(RestTemplate.class);
            restTemplate.addConstructorArgReference(factoryId);
            DefaultUriTemplateHandler handler = new DefaultUriTemplateHandler();
            handler.setBaseUrl(baseUrl);
            restTemplate.addPropertyValue("uriTemplateHandler", (Object)handler);
            AbstractBeanDefinition converters = BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethod("getConverters").getBeanDefinition();
            converters.setFactoryBeanName(convertersId);
            restTemplate.addPropertyValue("messageConverters", (Object)converters);
            return restTemplate;
        });
    }

    private String registerAsyncRestTemplate(String id, String factoryId, String convertersId, @Nullable String baseUrl) {
        return this.registry.register(id, AsyncRestTemplate.class, () -> {
            LOG.debug("Client [{}]: Registering AsyncRestTemplate", (Object)id);
            BeanDefinitionBuilder restTemplate = BeanDefinitionBuilder.genericBeanDefinition(AsyncRestTemplate.class);
            restTemplate.addConstructorArgReference(factoryId);
            DefaultUriTemplateHandler handler = new DefaultUriTemplateHandler();
            handler.setBaseUrl(baseUrl);
            restTemplate.addPropertyValue("uriTemplateHandler", (Object)handler);
            AbstractBeanDefinition converters = BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethod("getConverters").getBeanDefinition();
            converters.setFactoryBeanName(convertersId);
            restTemplate.addPropertyValue("messageConverters", (Object)converters);
            return restTemplate;
        });
    }

    private String registerAsyncListenableTaskExecutor(String id) {
        return this.registry.register(id, AsyncListenableTaskExecutor.class, () -> {
            LOG.debug("Client [{}]: Registering AsyncListenableTaskExecutor", (Object)id);
            return BeanDefinitionBuilder.genericBeanDefinition(ConcurrentTaskExecutor.class).addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(TracingExecutors.class).setFactoryMethod("preserve").addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(Executors.class).setFactoryMethod("newCachedThreadPool").setDestroyMethodName("shutdown").getBeanDefinition()).addConstructorArgReference("tracer").getBeanDefinition());
        });
    }

    private String registerAsyncClientHttpRequestFactory(String id, RestSettings.Defaults defaults, RestSettings.Client client) {
        return this.registry.register(id, AsyncClientHttpRequestFactory.class, () -> {
            LOG.debug("Client [{}]: Registering RestAsyncClientHttpRequestFactory", (Object)id);
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(RestAsyncClientHttpRequestFactory.class);
            factory.addConstructorArgReference(this.registerHttpClient(id, defaults, client));
            factory.addConstructorArgReference(this.registerAsyncListenableTaskExecutor(id));
            return factory;
        });
    }

    private String registerHttpClient(String id, RestSettings.Defaults defaults, RestSettings.Client client) {
        return this.registry.register(id, HttpClient.class, () -> {
            LOG.debug("Client [{}]: Registering HttpClient", (Object)id);
            BeanDefinitionBuilder httpClient = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
            this.configure(httpClient, id, defaults, client);
            this.configureInterceptors(httpClient, id, client);
            this.configureKeystore(httpClient, id, client.getKeystore());
            String customizerId = Registry.generateBeanName(id, HttpClientCustomizer.class);
            if (this.registry.isRegistered(customizerId)) {
                LOG.debug("Client [{}]: Customizing HttpClient with [{}]", (Object)id, (Object)customizerId);
                httpClient.addPropertyReference("customizer", customizerId);
            }
            return httpClient;
        });
    }

    private void configure(BeanDefinitionBuilder builder, String id, RestSettings.Defaults defaults, RestSettings.Client client) {
        this.configure(builder, id, "connectionTimeout", MoreObjects.firstNonNull((Object)client.getConnectionTimeout(), (Object)defaults.getConnectionTimeout()));
        this.configure(builder, id, "socketTimeout", MoreObjects.firstNonNull((Object)client.getSocketTimeout(), (Object)defaults.getSocketTimeout()));
        this.configure(builder, id, "connectionTimeToLive", MoreObjects.firstNonNull((Object)client.getConnectionTimeToLive(), (Object)defaults.getConnectionTimeToLive()));
        int maxConnectionsPerRoute = (Integer)MoreObjects.firstNonNull((Object)client.getMaxConnectionsPerRoute(), (Object)defaults.getMaxConnectionsPerRoute());
        this.configure(builder, id, "maxConnectionsPerRoute", maxConnectionsPerRoute);
        int maxConnectionsTotal = Math.max(maxConnectionsPerRoute, (Integer)MoreObjects.firstNonNull((Object)client.getMaxConnectionsTotal(), (Object)defaults.getMaxConnectionsTotal()));
        this.configure(builder, id, "maxConnectionsTotal", maxConnectionsTotal);
    }

    private void configure(BeanDefinitionBuilder bean, String id, String name, Object value) {
        LOG.debug("Client [{}]: Configuring {}: [{}]", new Object[]{id, name, value});
        bean.addPropertyValue(name, value);
    }

    private void configureInterceptors(BeanDefinitionBuilder builder, String id, RestSettings.Client client) {
        List<Object> requestInterceptors = Registry.list(new Object[0]);
        List<Object> responseInterceptors = Registry.list(new Object[0]);
        if (client.getOauth() != null) {
            LOG.debug("Client [{}]: Registering AccessTokensRequestInterceptor", (Object)id);
            requestInterceptors.add(BeanDefinitionBuilder.genericBeanDefinition(AccessTokensRequestInterceptor.class).addConstructorArgValue((Object)id).addConstructorArgReference(this.registerAccessTokens(id, this.getSettings())).getBeanDefinition());
        }
        LOG.debug("Client [{}]: Registering TracerHttpRequestInterceptor", (Object)id);
        requestInterceptors.add(Registry.ref("tracerHttpRequestInterceptor"));
        if (this.registry.isRegistered("zmonMetricsWrapper")) {
            LOG.debug("Client [{}]: Registering ZmonRequestInterceptor", (Object)id);
            requestInterceptors.add(BeanDefinitionBuilder.genericBeanDefinition(ZmonRequestInterceptor.class).getBeanDefinition());
            LOG.debug("Client [{}]: Registering ZmonResponseInterceptor", (Object)id);
            responseInterceptors.add(BeanDefinitionBuilder.genericBeanDefinition(ZmonResponseInterceptor.class).addConstructorArgValue((Object)Registry.ref("zmonMetricsWrapper")).getBeanDefinition());
        }
        LOG.debug("Client [{}]: Registering LogbookHttpResponseInterceptor", (Object)id);
        responseInterceptors.add(Registry.ref("logbookHttpResponseInterceptor"));
        LOG.debug("Client [{}]: Registering LogbookHttpRequestInterceptor", (Object)id);
        List<Object> lastRequestInterceptors = Registry.list(Registry.ref("logbookHttpRequestInterceptor"));
        if (client.isCompressRequest()) {
            LOG.debug("Client [{}]: Registering GzippingHttpRequestInterceptor", (Object)id);
            lastRequestInterceptors.add(new GzippingHttpRequestInterceptor());
        }
        builder.addPropertyValue("firstRequestInterceptors", requestInterceptors);
        builder.addPropertyValue("lastRequestInterceptors", lastRequestInterceptors);
        builder.addPropertyValue("lastResponseInterceptors", responseInterceptors);
    }

    private void configureKeystore(BeanDefinitionBuilder httpClient, String id, @Nullable RestSettings.Keystore keystore) {
        if (keystore != null) {
            LOG.debug("Client [{}]: Registering trusted keystore", (Object)id);
            httpClient.addPropertyValue("trustedKeystore", (Object)keystore);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

