/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.zalando.putittorest.TimeSpan;

public final class RestSettings {
    private final Defaults defaults = new Defaults();
    private final GlobalOAuth oauth = new GlobalOAuth();
    private final Map<String, Client> clients = new LinkedHashMap<String, Client>();

    public Defaults getDefaults() {
        return this.defaults;
    }

    public GlobalOAuth getOauth() {
        return this.oauth;
    }

    public Map<String, Client> getClients() {
        return this.clients;
    }

    public static final class Keystore {
        private String path;
        private String password;

        public String getPath() {
            return this.path;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static final class OAuth {
        private final List<String> scopes = new ArrayList<String>();

        public List<String> getScopes() {
            return this.scopes;
        }
    }

    public static final class Client {
        private String baseUrl;
        private TimeSpan connectionTimeout;
        private TimeSpan socketTimeout;
        private TimeSpan connectionTimeToLive;
        private Integer maxConnectionsPerRoute;
        private Integer maxConnectionsTotal;
        private OAuth oauth;
        private final List<String> plugins = new ArrayList<String>();
        private boolean compressRequest = false;
        private Keystore keystore;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public TimeSpan getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public TimeSpan getSocketTimeout() {
            return this.socketTimeout;
        }

        public TimeSpan getConnectionTimeToLive() {
            return this.connectionTimeToLive;
        }

        public Integer getMaxConnectionsPerRoute() {
            return this.maxConnectionsPerRoute;
        }

        public Integer getMaxConnectionsTotal() {
            return this.maxConnectionsTotal;
        }

        public OAuth getOauth() {
            return this.oauth;
        }

        public List<String> getPlugins() {
            return this.plugins;
        }

        public boolean isCompressRequest() {
            return this.compressRequest;
        }

        public Keystore getKeystore() {
            return this.keystore;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setConnectionTimeout(TimeSpan connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setSocketTimeout(TimeSpan socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public void setConnectionTimeToLive(TimeSpan connectionTimeToLive) {
            this.connectionTimeToLive = connectionTimeToLive;
        }

        public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        }

        public void setMaxConnectionsTotal(Integer maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
        }

        public void setOauth(OAuth oauth) {
            this.oauth = oauth;
        }

        public void setCompressRequest(boolean compressRequest) {
            this.compressRequest = compressRequest;
        }

        public void setKeystore(Keystore keystore) {
            this.keystore = keystore;
        }
    }

    public static final class GlobalOAuth {
        private URI accessTokenUrl;
        private TimeSpan schedulingPeriod = TimeSpan.of(5L, TimeUnit.SECONDS);
        private TimeSpan connectionTimeout = TimeSpan.of(1L, TimeUnit.SECONDS);
        private TimeSpan socketTimeout = TimeSpan.of(2L, TimeUnit.SECONDS);

        public URI getAccessTokenUrl() {
            return this.accessTokenUrl;
        }

        public TimeSpan getSchedulingPeriod() {
            return this.schedulingPeriod;
        }

        public TimeSpan getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public TimeSpan getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setAccessTokenUrl(URI accessTokenUrl) {
            this.accessTokenUrl = accessTokenUrl;
        }

        public void setSchedulingPeriod(TimeSpan schedulingPeriod) {
            this.schedulingPeriod = schedulingPeriod;
        }

        public void setConnectionTimeout(TimeSpan connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setSocketTimeout(TimeSpan socketTimeout) {
            this.socketTimeout = socketTimeout;
        }
    }

    public static final class Defaults {
        static final List<String> PLUGINS = ImmutableList.of((Object)"original-stack-trace");
        private TimeSpan connectionTimeout = TimeSpan.of(5L, TimeUnit.SECONDS);
        private TimeSpan socketTimeout = TimeSpan.of(5L, TimeUnit.SECONDS);
        private TimeSpan connectionTimeToLive = TimeSpan.of(30L, TimeUnit.SECONDS);
        private int maxConnectionsPerRoute = 2;
        private int maxConnectionsTotal = 20;
        private final List<String> plugins = new ArrayList<String>();

        public TimeSpan getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public TimeSpan getSocketTimeout() {
            return this.socketTimeout;
        }

        public TimeSpan getConnectionTimeToLive() {
            return this.connectionTimeToLive;
        }

        public int getMaxConnectionsPerRoute() {
            return this.maxConnectionsPerRoute;
        }

        public int getMaxConnectionsTotal() {
            return this.maxConnectionsTotal;
        }

        public List<String> getPlugins() {
            return this.plugins;
        }

        public void setConnectionTimeout(TimeSpan connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setSocketTimeout(TimeSpan socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public void setConnectionTimeToLive(TimeSpan connectionTimeToLive) {
            this.connectionTimeToLive = connectionTimeToLive;
        }

        public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        }

        public void setMaxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
        }
    }
}

