/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TimeSpan {
    static final TimeSpan ZERO = new TimeSpan(0L, TimeUnit.NANOSECONDS);
    private static final Map<String, TimeUnit> UNITS = Arrays.stream(TimeUnit.values()).collect(Collectors.toMap(TimeSpan::toName, Function.identity(), (u, v) -> u, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    private static final Splitter PARTS = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter DURATION = Splitter.on((char)' ').trimResults().omitEmptyStrings().limit(2);
    private final long amount;
    private final TimeUnit unit;

    public TimeSpan(String value) {
        this(TimeSpan.valueOf(value));
    }

    private TimeSpan(TimeSpan span) {
        this(span.getAmount(), span.getUnit());
    }

    TimeSpan plus(TimeSpan span) {
        switch (Integer.signum(this.unit.compareTo(span.getUnit()))) {
            case -1: {
                return span.addTo(this);
            }
            case 1: {
                return this.addTo(span);
            }
        }
        return new TimeSpan(this.amount + span.getAmount(), this.unit);
    }

    private TimeSpan addTo(TimeSpan span) {
        return new TimeSpan(span.getAmount() + span.getUnit().convert(this.amount, this.unit), span.getUnit());
    }

    long to(TimeUnit targetUnit) {
        return targetUnit.convert(this.amount, this.unit);
    }

    public String toString() {
        return this.amount + " " + TimeSpan.toName(this.unit);
    }

    static TimeSpan valueOf(String value) {
        return PARTS.splitToList((CharSequence)value).stream().map(TimeSpan::parse).reduce(TimeSpan::plus).orElse(ZERO);
    }

    private static TimeSpan parse(String part) {
        List parts = DURATION.splitToList((CharSequence)part);
        long amount = Long.parseLong((String)parts.get(0));
        TimeUnit unit = TimeSpan.fromName((String)parts.get(1));
        return new TimeSpan(amount, unit);
    }

    private static TimeUnit fromName(String name) {
        TimeUnit unit = UNITS.get(name.endsWith("s") ? name : name + "s");
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (String)"Unknown time unit: [%s]", (Object)name);
        return unit;
    }

    private static String toName(TimeUnit unit) {
        return unit.name().toLowerCase(Locale.ROOT);
    }

    @ConstructorProperties(value={"amount", "unit"})
    private TimeSpan(long amount, TimeUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public static TimeSpan of(long amount, TimeUnit unit) {
        return new TimeSpan(amount, unit);
    }

    public long getAmount() {
        return this.amount;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }
}

