/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest.zmon;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.zalando.putittorest.zmon.Timing;

public class ZmonRequestInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            context.setAttribute(Timing.ATTRIBUTE, (Object)this.assemble(request));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Timing assemble(HttpRequest request) throws URISyntaxException {
        RequestLine requestLine = request.getRequestLine();
        return new Timing(requestLine.getMethod(), this.getHost(request), System.currentTimeMillis());
    }

    private String getHost(HttpRequest request) throws URISyntaxException {
        URI uri = this.getUri(request);
        int port = uri.getPort();
        return (String)Preconditions.checkNotNull((Object)uri.getHost()) + (port == -1 ? "" : ":" + port);
    }

    private URI getUri(HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            return this.getUri(((HttpRequestWrapper)request).getOriginal());
        }
        return URI.create(request.getRequestLine().getUri());
    }
}

