/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.springframework.beans.factory.FactoryBean;
import org.zalando.putittorest.GlobalOAuth;
import org.zalando.putittorest.OAuth;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.Timeouts;
import org.zalando.stups.tokens.AccessTokens;
import org.zalando.stups.tokens.AccessTokensBuilder;
import org.zalando.stups.tokens.Tokens;

class AccessTokensFactoryBean
implements FactoryBean<AccessTokens> {
    private AccessTokensBuilder builder;

    AccessTokensFactoryBean() {
    }

    public void setSettings(RestSettings settings) {
        GlobalOAuth oAuth = settings.getOauth();
        Timeouts timeouts = oAuth.getTimeouts();
        URI accessTokenUrl = this.getAccessTokenUrl(oAuth);
        this.builder = Tokens.createAccessTokensWithUri((URI)accessTokenUrl).schedulingPeriod(oAuth.getSchedulingPeriod()).connectTimeout(Timeouts.toMillis(timeouts.getConnect())).socketTimeout(Timeouts.toMillis(timeouts.getRead()));
        settings.getClients().forEach((id, client) -> {
            OAuth clientOAuth = client.getOauth();
            if (clientOAuth == null) {
                return;
            }
            this.builder.manageToken(id).addScopes(clientOAuth.getScopes()).done();
        });
    }

    private URI getAccessTokenUrl(GlobalOAuth oauth) {
        URI accessTokenUrl = oauth.getAccessTokenUrl();
        if (accessTokenUrl == null) {
            String env = System.getenv("ACCESS_TOKEN_URL");
            Preconditions.checkArgument((env != null ? 1 : 0) != 0, (Object)"Neither 'rest.oauth.access-token-url' nor 'ACCESS_TOKEN_URL' was set, but at least one client requires OAuth");
            return URI.create(env);
        }
        return accessTokenUrl;
    }

    public AccessTokens getObject() {
        return this.builder.start();
    }

    public Class<?> getObjectType() {
        return AccessTokens.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

