/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.gag.annotation.remark.Hack;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.zalando.putittorest.AccessTokensFactoryBean;
import org.zalando.putittorest.Client;
import org.zalando.putittorest.HttpAsyncClientFactoryBean;
import org.zalando.putittorest.HttpClientFactoryBean;
import org.zalando.putittorest.OAuth;
import org.zalando.putittorest.Registry;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.Timeouts;
import org.zalando.riptide.AsyncRest;
import org.zalando.riptide.PassThroughResponseErrorHandler;
import org.zalando.riptide.Rest;
import org.zalando.stups.oauth2.spring.client.StupsOAuth2RestTemplate;
import org.zalando.stups.oauth2.spring.client.StupsTokensAccessTokenProvider;
import org.zalando.stups.tokens.AccessTokens;

public class RestClientPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private ConfigurableEnvironment environment;
    private Registry registry;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        RestSettings settings = this.getSettings();
        this.registry = new Registry(beanDefinitionRegistry);
        settings.getClients().forEach((id, client) -> {
            OAuth oauth = client.getOauth();
            Timeouts timeouts = client.getTimeouts();
            String templateId = Registry.generateBeanName(id, RestTemplate.class);
            if (this.registry.isNotRegistered(templateId)) {
                String factoryId = this.registerClientHttpRequestFactory((String)id, timeouts);
                String convertersId = this.registerHttpMessageConverters((String)id);
                if (oauth == null) {
                    this.registerRestTemplate((String)id, (Client)client, factoryId, convertersId);
                } else {
                    this.registerStupsOAuth2RestTemplate(settings, (String)id, (Client)client, factoryId, convertersId);
                }
            }
            this.registerRest((String)id, templateId);
            this.registerAsyncRest((String)id, timeouts, templateId);
        });
    }

    @VisibleForTesting
    RestSettings getSettings() {
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(RestSettings.class);
        factory.setTargetName("rest");
        factory.setPropertySources((PropertySources)this.environment.getPropertySources());
        factory.setConversionService((ConversionService)this.environment.getConversionService());
        return (RestSettings)factory.getObject();
    }

    private String registerClientHttpRequestFactory(String id, Timeouts timeouts) {
        return this.registry.register(id, ClientHttpRequestFactory.class, () -> {
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(HttpComponentsClientHttpRequestFactory.class);
            factory.addConstructorArgReference(this.registerHttpClient(id));
            this.configureTimeouts(factory, timeouts);
            return factory;
        });
    }

    private String registerHttpClient(String id) {
        return this.registry.register(id, HttpClient.class, () -> {
            BeanDefinitionBuilder httpClient = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
            this.configureInterceptors(httpClient);
            return httpClient;
        });
    }

    private void configureTimeouts(BeanDefinitionBuilder builder, Timeouts timeouts) {
        builder.addPropertyValue("connectTimeout", (Object)((int)TimeUnit.SECONDS.toMillis(timeouts.getConnect())));
        builder.addPropertyValue("readTimeout", (Object)((int)TimeUnit.SECONDS.toMillis(timeouts.getRead())));
    }

    private String registerHttpMessageConverters(String id) {
        return this.registry.register(id, HttpMessageConverters.class, () -> BeanDefinitionBuilder.genericBeanDefinition(HttpMessageConverters.class).addConstructorArgValue((Object)false).addConstructorArgValue(Registry.list(BeanDefinitionBuilder.genericBeanDefinition(StringHttpMessageConverter.class).addPropertyValue("writeAcceptCharset", (Object)false).getBeanDefinition(), BeanDefinitionBuilder.genericBeanDefinition(MappingJackson2HttpMessageConverter.class).addConstructorArgReference(this.findObjectMapper(id)).getBeanDefinition())));
    }

    private String findObjectMapper(String id) {
        String beanName = Registry.generateBeanName(id, ObjectMapper.class);
        return this.registry.isRegistered(beanName) ? beanName : "objectMapper";
    }

    private String registerRestTemplate(String id, Client client, String httpClientFactoryId, String httpMessageConvertersId) {
        return this.registry.register(id, RestTemplate.class, () -> {
            BeanDefinitionBuilder template = BeanDefinitionBuilder.genericBeanDefinition(RestTemplate.class);
            template.addConstructorArgReference(httpClientFactoryId);
            this.configureRestTemplate(template, client, httpMessageConvertersId);
            return template;
        });
    }

    private String registerStupsOAuth2RestTemplate(RestSettings settings, String id, Client client, String httpClientFactoryId, String httpMessageConvertersId) {
        return this.registry.register(id, RestTemplate.class, () -> {
            BeanDefinitionBuilder template = BeanDefinitionBuilder.genericBeanDefinition(StupsOAuth2RestTemplate.class);
            template.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(StupsTokensAccessTokenProvider.class).addConstructorArgValue((Object)id).addConstructorArgReference(this.registerAccessTokens(settings)).getBeanDefinition());
            template.addConstructorArgReference(httpClientFactoryId);
            this.configureRestTemplate(template, client, httpMessageConvertersId);
            return template;
        });
    }

    private void configureRestTemplate(BeanDefinitionBuilder builder, Client client, String messageConvertersId) {
        builder.addPropertyValue("errorHandler", (Object)new PassThroughResponseErrorHandler());
        DefaultUriTemplateHandler handler = new DefaultUriTemplateHandler();
        handler.setBaseUrl(client.getBaseUrl());
        builder.addPropertyValue("uriTemplateHandler", (Object)handler);
        AbstractBeanDefinition converters = BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethod("getConverters").getBeanDefinition();
        converters.setFactoryBeanName(messageConvertersId);
        builder.addPropertyValue("messageConverters", (Object)converters);
    }

    private String registerAccessTokens(RestSettings settings) {
        return this.registry.register(AccessTokens.class, () -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AccessTokensFactoryBean.class);
            builder.addPropertyValue("settings", (Object)settings);
            return builder;
        });
    }

    private String registerRest(String id, String restTemplateId) {
        return this.registry.register(id, Rest.class, () -> {
            BeanDefinitionBuilder rest = BeanDefinitionBuilder.genericBeanDefinition(Rest.class);
            rest.setFactoryMethod("create");
            rest.addConstructorArgReference(restTemplateId);
            return rest;
        });
    }

    private String registerAsyncRest(String id, Timeouts timeouts, String restTemplateId) {
        return this.registry.register(id, AsyncRest.class, () -> {
            BeanDefinitionBuilder rest = BeanDefinitionBuilder.genericBeanDefinition(AsyncRest.class);
            rest.setFactoryMethod("create");
            rest.addConstructorArgReference(this.registerAsyncRestTemplate(id, timeouts, restTemplateId));
            return rest;
        });
    }

    private String registerAsyncRestTemplate(String id, Timeouts timeouts, String restTemplateId) {
        return this.registry.register(id, AsyncRestTemplate.class, () -> {
            BeanDefinitionBuilder template = BeanDefinitionBuilder.genericBeanDefinition(AsyncRestTemplate.class);
            template.addConstructorArgReference(this.registerAsyncClientHttpRequestFactory(id, timeouts));
            template.addConstructorArgReference(restTemplateId);
            return template;
        });
    }

    private String registerAsyncClientHttpRequestFactory(String id, Timeouts timeouts) {
        return this.registry.register(id, AsyncClientHttpRequestFactory.class, () -> {
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(HttpComponentsAsyncClientHttpRequestFactory.class);
            factory.addConstructorArgReference(this.registerHttpAsyncClient(id));
            this.configureTimeouts(factory, timeouts);
            return factory;
        });
    }

    private String registerHttpAsyncClient(String id) {
        return this.registry.register(id, HttpAsyncClient.class, () -> {
            BeanDefinitionBuilder httpClient = BeanDefinitionBuilder.genericBeanDefinition(HttpAsyncClientFactoryBean.class);
            this.configureInterceptors(httpClient);
            return httpClient;
        });
    }

    @Hack(value="In order to avoid a runtime dependency on Tracer and Logbook")
    private void configureInterceptors(BeanDefinitionBuilder builder) {
        if (this.registry.isRegistered("tracerHttpRequestInterceptor")) {
            builder.addPropertyValue("firstRequestInterceptors", Registry.list(Registry.ref("tracerHttpRequestInterceptor")));
        }
        if (this.registry.isRegistered("logbookHttpRequestInterceptor")) {
            builder.addPropertyValue("lastRequestInterceptors", Registry.list(Registry.ref("logbookHttpRequestInterceptor")));
        }
        if (this.registry.isRegistered("logbookHttpResponseInterceptor")) {
            builder.addPropertyValue("lastResponseInterceptors", Registry.list(Registry.ref("logbookHttpResponseInterceptor")));
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

