/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.gag.annotation.remark.Hack;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.nio.client.HttpAsyncClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.zalando.putittorest.AccessTokensFactoryBean;
import org.zalando.putittorest.HttpAsyncClientFactoryBean;
import org.zalando.putittorest.OAuth;
import org.zalando.putittorest.Registry;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.Timeouts;
import org.zalando.riptide.Rest;
import org.zalando.stups.oauth2.httpcomponents.AccessTokensRequestInterceptor;
import org.zalando.stups.tokens.AccessTokens;

public class RestClientPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private ConfigurableEnvironment environment;
    private Registry registry;
    private RestSettings settings;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.registry = new Registry(beanDefinitionRegistry);
        this.getSettings().getClients().forEach((id, client) -> {
            OAuth oauth = client.getOauth();
            Timeouts timeouts = client.getTimeouts();
            String baseUrl = client.getBaseUrl();
            String convertersId = this.registerHttpMessageConverters((String)id);
            String asyncFactoryId = this.registerAsyncClientHttpRequestFactory((String)id, timeouts, oauth);
            this.registerRest((String)id, asyncFactoryId, convertersId, baseUrl);
        });
    }

    @VisibleForTesting
    RestSettings getSettings() {
        if (this.settings == null) {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(RestSettings.class);
            factory.setTargetName("rest");
            factory.setPropertySources((PropertySources)this.environment.getPropertySources());
            factory.setConversionService((ConversionService)this.environment.getConversionService());
            this.settings = (RestSettings)factory.getObject();
        }
        return this.settings;
    }

    private void configureTimeouts(BeanDefinitionBuilder builder, Timeouts timeouts) {
        builder.addPropertyValue("connectTimeout", (Object)((int)timeouts.getConnectUnit().toMillis(timeouts.getConnect())));
        builder.addPropertyValue("readTimeout", (Object)((int)timeouts.getReadUnit().toMillis(timeouts.getRead())));
    }

    private String registerHttpMessageConverters(String id) {
        return this.registry.register(id, HttpMessageConverters.class, () -> BeanDefinitionBuilder.genericBeanDefinition(HttpMessageConverters.class).addConstructorArgValue((Object)false).addConstructorArgValue(Registry.list(BeanDefinitionBuilder.genericBeanDefinition(StringHttpMessageConverter.class).addPropertyValue("writeAcceptCharset", (Object)false).getBeanDefinition(), BeanDefinitionBuilder.genericBeanDefinition(MappingJackson2HttpMessageConverter.class).addConstructorArgReference(this.findObjectMapper(id)).getBeanDefinition())));
    }

    private String findObjectMapper(String id) {
        String beanName = Registry.generateBeanName(id, ObjectMapper.class);
        return this.registry.isRegistered(beanName) ? beanName : "jacksonObjectMapper";
    }

    private String registerAccessTokens(RestSettings settings) {
        return this.registry.register(AccessTokens.class, () -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AccessTokensFactoryBean.class);
            builder.addPropertyValue("settings", (Object)settings);
            return builder;
        });
    }

    private String registerRest(String id, String factoryId, String convertersId, @Nullable String baseUrl) {
        return this.registry.register(id, Rest.class, () -> {
            BeanDefinitionBuilder rest = BeanDefinitionBuilder.genericBeanDefinition(Rest.class);
            rest.setFactoryMethod("create");
            rest.addConstructorArgReference(factoryId);
            AbstractBeanDefinition converters = BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethod("getConverters").getBeanDefinition();
            converters.setFactoryBeanName(convertersId);
            rest.addConstructorArgValue((Object)converters);
            DefaultUriTemplateHandler handler = new DefaultUriTemplateHandler();
            handler.setBaseUrl(baseUrl);
            rest.addConstructorArgValue((Object)handler);
            return rest;
        });
    }

    private String registerAsyncClientHttpRequestFactory(String id, Timeouts timeouts, @Nullable OAuth oauth) {
        return this.registry.register(id, AsyncClientHttpRequestFactory.class, () -> {
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(HttpComponentsAsyncClientHttpRequestFactory.class);
            factory.addConstructorArgReference(this.registerHttpAsyncClient(id, oauth));
            this.configureTimeouts(factory, timeouts);
            return factory;
        });
    }

    private String registerHttpAsyncClient(String id, @Nullable OAuth oauth) {
        return this.registry.register(id, HttpAsyncClient.class, () -> {
            BeanDefinitionBuilder httpClient = BeanDefinitionBuilder.genericBeanDefinition(HttpAsyncClientFactoryBean.class);
            this.configureInterceptors(httpClient, id, oauth);
            return httpClient;
        });
    }

    @Hack(value="In order to avoid any runtime dependency")
    private void configureInterceptors(BeanDefinitionBuilder builder, String id, @Nullable OAuth oauth) {
        List<Object> requestInterceptors = Registry.list(new Object[0]);
        if (oauth != null) {
            requestInterceptors.add(BeanDefinitionBuilder.genericBeanDefinition(AccessTokensRequestInterceptor.class).addConstructorArgValue((Object)id).addConstructorArgReference(this.registerAccessTokens(this.getSettings())).getBeanDefinition());
        }
        if (this.registry.isRegistered("tracerHttpRequestInterceptor")) {
            requestInterceptors.add(Registry.ref("tracerHttpRequestInterceptor"));
        }
        builder.addPropertyValue("firstRequestInterceptors", requestInterceptors);
        if (this.registry.isRegistered("logbookHttpRequestInterceptor")) {
            builder.addPropertyValue("lastRequestInterceptors", Registry.list(Registry.ref("logbookHttpRequestInterceptor")));
        }
        if (this.registry.isRegistered("logbookHttpResponseInterceptor")) {
            builder.addPropertyValue("lastResponseInterceptors", Registry.list(Registry.ref("logbookHttpResponseInterceptor")));
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

