/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;
import org.zalando.putittorest.AccessTokensFactoryBean;
import org.zalando.putittorest.Client;
import org.zalando.putittorest.ClientHttpMessageConverters;
import org.zalando.putittorest.HttpClientFactoryBean;
import org.zalando.putittorest.OAuth;
import org.zalando.putittorest.Registry;
import org.zalando.putittorest.RestSettings;
import org.zalando.putittorest.Timeouts;
import org.zalando.riptide.Rest;
import org.zalando.riptide.httpclient.RestAsyncClientHttpRequestFactory;
import org.zalando.riptide.stream.Streams;
import org.zalando.stups.oauth2.httpcomponents.AccessTokensRequestInterceptor;
import org.zalando.stups.tokens.AccessTokens;
import org.zalando.tracer.concurrent.TracingExecutors;

public class RestClientPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private ConfigurableEnvironment environment;
    private Registry registry;
    private RestSettings settings;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.registry = new Registry(beanDefinitionRegistry);
        this.getSettings().getClients().forEach((id, client) -> {
            String baseUrl = client.getBaseUrl();
            String convertersId = this.registerHttpMessageConverters((String)id);
            String asyncFactoryId = this.registerAsyncClientHttpRequestFactory((String)id, (Client)client);
            this.registerRest((String)id, asyncFactoryId, convertersId, baseUrl);
        });
    }

    @VisibleForTesting
    RestSettings getSettings() {
        if (this.settings == null) {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(RestSettings.class);
            factory.setTargetName("rest");
            factory.setPropertySources((PropertySources)this.environment.getPropertySources());
            factory.setConversionService((ConversionService)this.environment.getConversionService());
            this.settings = (RestSettings)factory.getObject();
        }
        return this.settings;
    }

    private String registerHttpMessageConverters(String id) {
        return this.registry.register(id, HttpMessageConverters.class, () -> {
            List<Object> list = Registry.list(new Object[0]);
            list.add(BeanDefinitionBuilder.genericBeanDefinition(StringHttpMessageConverter.class).addPropertyValue("writeAcceptCharset", (Object)false).getBeanDefinition());
            String objectMapperId = this.findObjectMapper(id);
            list.add(BeanDefinitionBuilder.genericBeanDefinition(MappingJackson2HttpMessageConverter.class).addConstructorArgReference(objectMapperId).getBeanDefinition());
            list.add(BeanDefinitionBuilder.genericBeanDefinition(Streams.class).setFactoryMethod("streamConverter").addConstructorArgReference(objectMapperId).getBeanDefinition());
            return BeanDefinitionBuilder.genericBeanDefinition(ClientHttpMessageConverters.class).addConstructorArgValue(list);
        });
    }

    private String findObjectMapper(String id) {
        String beanName = Registry.generateBeanName(id, ObjectMapper.class);
        return this.registry.isRegistered(beanName) ? beanName : "jacksonObjectMapper";
    }

    private String registerAccessTokens(RestSettings settings) {
        return this.registry.register(AccessTokens.class, () -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AccessTokensFactoryBean.class);
            builder.addPropertyValue("settings", (Object)settings);
            return builder;
        });
    }

    private String registerRest(String id, String factoryId, String convertersId, @Nullable String baseUrl) {
        return this.registry.register(id, Rest.class, () -> {
            BeanDefinitionBuilder rest = BeanDefinitionBuilder.genericBeanDefinition(Rest.class);
            rest.setFactoryMethod("create");
            rest.addConstructorArgReference(factoryId);
            AbstractBeanDefinition converters = BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethod("getConverters").getBeanDefinition();
            converters.setFactoryBeanName(convertersId);
            rest.addConstructorArgValue((Object)converters);
            rest.addConstructorArgValue((Object)this.newUriTemplateHandler(baseUrl));
            return rest;
        });
    }

    private UriTemplateHandler newUriTemplateHandler(@Nullable String baseUrl) {
        DefaultUriTemplateHandler handler = new DefaultUriTemplateHandler();
        handler.setBaseUrl(baseUrl);
        return handler;
    }

    private String registerAsyncClientHttpRequestFactory(String id, Client client) {
        return this.registry.register(id, AsyncClientHttpRequestFactory.class, () -> {
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(RestAsyncClientHttpRequestFactory.class);
            factory.addConstructorArgReference(this.registerHttpClient(id, client));
            factory.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(ConcurrentTaskExecutor.class).addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(TracingExecutors.class).setFactoryMethod("preserve").addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(Executors.class).setFactoryMethod("newCachedThreadPool").setDestroyMethodName("shutdown").getBeanDefinition()).addConstructorArgReference("tracer").getBeanDefinition()).getBeanDefinition());
            return factory;
        });
    }

    private String registerHttpClient(String id, Client client) {
        return this.registry.register(id, HttpClient.class, () -> {
            BeanDefinitionBuilder httpClient = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
            this.configureTimeouts(httpClient, client.getTimeouts());
            this.configureInterceptors(httpClient, id, client.getOauth());
            return httpClient;
        });
    }

    private void configureTimeouts(BeanDefinitionBuilder builder, Timeouts timeouts) {
        builder.addPropertyValue("connectTimeout", (Object)((int)timeouts.getConnectUnit().toMillis(timeouts.getConnect())));
        builder.addPropertyValue("socketTimeout", (Object)((int)timeouts.getReadUnit().toMillis(timeouts.getRead())));
    }

    private void configureInterceptors(BeanDefinitionBuilder builder, String id, @Nullable OAuth oauth) {
        List<Object> requestInterceptors = Registry.list(new Object[0]);
        if (oauth != null) {
            requestInterceptors.add(BeanDefinitionBuilder.genericBeanDefinition(AccessTokensRequestInterceptor.class).addConstructorArgValue((Object)id).addConstructorArgReference(this.registerAccessTokens(this.getSettings())).getBeanDefinition());
        }
        requestInterceptors.add(Registry.ref("tracerHttpRequestInterceptor"));
        builder.addPropertyValue("firstRequestInterceptors", requestInterceptors);
        builder.addPropertyValue("lastRequestInterceptors", Registry.list(Registry.ref("logbookHttpRequestInterceptor")));
        builder.addPropertyValue("lastResponseInterceptors", Registry.list(Registry.ref("logbookHttpResponseInterceptor")));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

