/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.stereotype.Component;
import org.zalando.putittorest.HttpClientCustomizer;

@Component
class HttpClientFactoryBean
implements FactoryBean<HttpClient> {
    private final HttpClientBuilder builder = HttpClientBuilder.create();
    private final RequestConfig.Builder config = RequestConfig.custom();
    private HttpClientCustomizer customizer = $ -> {};

    HttpClientFactoryBean() {
    }

    public void setFirstRequestInterceptors(List<HttpRequestInterceptor> interceptors) {
        interceptors.forEach(arg_0 -> ((HttpClientBuilder)this.builder).addInterceptorFirst(arg_0));
    }

    public void setLastRequestInterceptors(List<HttpRequestInterceptor> interceptors) {
        interceptors.forEach(arg_0 -> ((HttpClientBuilder)this.builder).addInterceptorLast(arg_0));
    }

    public void setLastResponseInterceptors(List<HttpResponseInterceptor> interceptors) {
        interceptors.forEach(arg_0 -> ((HttpClientBuilder)this.builder).addInterceptorLast(arg_0));
    }

    public void setConnectTimeout(int connectTimeout) {
        this.config.setConnectTimeout(connectTimeout);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.config.setSocketTimeout(socketTimeout);
    }

    public void setCustomizer(HttpClientCustomizer customizer) {
        this.customizer = customizer;
    }

    public CloseableHttpClient getObject() {
        this.builder.setDefaultRequestConfig(this.config.build());
        this.builder.setConnectionTimeToLive(30L, TimeUnit.SECONDS);
        this.customizer.customize(this.builder);
        return this.builder.build();
    }

    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

