/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.putittorest.zmon;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.protocol.HttpContext;
import org.zalando.putittorest.zmon.Timing;

public class ZmonRequestInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            context.setAttribute(Timing.ATTRIBUTE, (Object)this.assemble(request));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Timing assemble(HttpRequest request) throws URISyntaxException {
        RequestLine requestLine = request.getRequestLine();
        return new Timing(requestLine.getMethod(), this.getHost(requestLine), System.currentTimeMillis());
    }

    private String getHost(RequestLine requestLine) throws URISyntaxException {
        URI uri = new URI(requestLine.getUri());
        int port = uri.getPort();
        return (String)Preconditions.checkNotNull((Object)uri.getHost()) + (port == -1 ? "" : ":" + port);
    }
}

