/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.resourcelock.sample.service;

import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.zalando.resourcelock.ResourceLockManager;

@Component
public class SampleJob {
    @Autowired
    private ResourceLockManager resourceLockManager;

    @Scheduled(fixedDelay=1000L)
    public void doSomething() {
        UUID lockName = UUID.randomUUID();
        try {
            if (this.resourceLockManager.acquireLock("sample-job", lockName.toString())) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.resourceLockManager.releaseLock("sample-job", lockName.toString());
        }
    }
}

