/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.resourcelock;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.boot.etcd.EtcdClient;
import org.zalando.boot.etcd.EtcdError;
import org.zalando.boot.etcd.EtcdException;
import org.zalando.resourcelock.ResourceLockException;
import org.zalando.resourcelock.ResourceLockManager;

public class ResourceLockManagerEtcdImpl
implements ResourceLockManager {
    private static final Logger log = LoggerFactory.getLogger(ResourceLockManagerEtcdImpl.class);
    private static final String RESOURCE_LOCK_PREFIX = "resource-locks";
    private EtcdClient etcdClient;
    private String applicationName;

    public ResourceLockManagerEtcdImpl(EtcdClient etcdClient, String applicationName) {
        this.etcdClient = etcdClient;
        this.applicationName = applicationName;
    }

    private String createApplicationKey(String name) {
        return this.applicationName + "/" + name;
    }

    @Override
    public boolean acquireLock(String resourceName, String lockName) {
        String key = this.createApplicationKey(RESOURCE_LOCK_PREFIX + File.separator + resourceName);
        try {
            this.etcdClient.compareAndSwap(key, lockName, false);
            return true;
        }
        catch (EtcdException e) {
            log.warn("Unable to acquirer lock {} for resource {} with key {}.", new Object[]{lockName, resourceName, key, e});
            return false;
        }
    }

    @Override
    public boolean acquireLock(String resourceName, String lockName, int ttl) {
        String key = this.createApplicationKey(RESOURCE_LOCK_PREFIX + File.separator + resourceName);
        try {
            this.etcdClient.compareAndSwap(key, lockName, ttl, false);
            return true;
        }
        catch (EtcdException e) {
            log.warn("Unable to acquirer lock {} for resource {} with key {}.", new Object[]{lockName, resourceName, key, e});
            return false;
        }
    }

    @Override
    public void releaseLock(String resourceName, String lockName) {
        block2: {
            String key = this.createApplicationKey(RESOURCE_LOCK_PREFIX + File.separator + resourceName);
            try {
                this.etcdClient.compareAndDelete(key, lockName);
            }
            catch (EtcdException e) {
                EtcdError error = e.getError();
                if (error != null && error.getErrorCode() == 100) break block2;
                throw new ResourceLockException("Could not release lock with key " + key + ".", e);
            }
        }
    }
}

