/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.resourcelock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.resourcelock.ResourceLockManager;

@Transactional(propagation=Propagation.REQUIRES_NEW)
public class ResourceLockManagerJdbcFunctionImpl
implements ResourceLockManager {
    private JdbcTemplate template;

    public ResourceLockManagerJdbcFunctionImpl(JdbcTemplate template) {
        this.template = template;
    }

    @Override
    public boolean acquireLock(String resourceName, String lockName) {
        return this.acquireLock(resourceName, lockName, 0);
    }

    @Override
    public boolean acquireLock(String resourceName, String lockName, int ttl) {
        try {
            this.template.query("SELECT acquire_resource_lock(?, ?, ?);", new Object[]{resourceName, lockName, ttl == 0 ? null : DateUtils.addSeconds((Date)new Date(), (int)ttl)}, (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return null;
                }
            });
            return true;
        }
        catch (DuplicateKeyException e) {
            return false;
        }
    }

    @Override
    public void releaseLock(String resourceName, String lockName) {
        this.template.query("SELECT release_resource_lock(?, ?);", new Object[]{resourceName, lockName}, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                return null;
            }
        });
    }
}

