/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.resourcelock;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.resourcelock.ResourceLockManager;

@Transactional(propagation=Propagation.REQUIRES_NEW)
public class ResourceLockManagerJdbcImpl
implements ResourceLockManager {
    private static final String TABLE_NAME = "resource_lock";
    private static final String COLUMN_RESOURCE_NAME = "resource_name";
    private static final String COLUMN_LOCK_NAME = "lock_name";
    private static final String COLUMN_CREATED_AT = "created_at";
    private static final String COLUMN_EXPIRES_AT = "expires_at";
    private JdbcTemplate template;

    public ResourceLockManagerJdbcImpl(JdbcTemplate template) {
        this.template = template;
    }

    @Override
    public boolean acquireLock(String resourceName, String lockName) {
        return this.acquireLock(resourceName, lockName, 0);
    }

    @Override
    public boolean acquireLock(String resourceName, String lockName, int ttl) {
        try {
            Date now = new Date();
            this.template.update(String.format("DELETE FROM %s WHERE %s = ? AND %s IS NOT NULL AND %s < ?", TABLE_NAME, COLUMN_RESOURCE_NAME, COLUMN_EXPIRES_AT, COLUMN_EXPIRES_AT), new Object[]{resourceName, now});
            this.template.update(String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", TABLE_NAME, COLUMN_RESOURCE_NAME, COLUMN_LOCK_NAME, COLUMN_CREATED_AT, COLUMN_EXPIRES_AT), new Object[]{resourceName, lockName, now, ttl == 0 ? null : DateUtils.addSeconds((Date)now, (int)ttl)});
            return true;
        }
        catch (DuplicateKeyException e) {
            return false;
        }
    }

    @Override
    public void releaseLock(String resourceName, String lockName) {
        this.template.update(String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", TABLE_NAME, COLUMN_RESOURCE_NAME, COLUMN_LOCK_NAME), new Object[]{resourceName, lockName});
    }
}

