/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.auth;

import com.google.common.base.Preconditions;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.zalando.riptide.auth.AuthorizationProvider;

public final class BasicAuthorizationProvider
implements AuthorizationProvider {
    private final String authorization;

    public BasicAuthorizationProvider(String username, String password) {
        Preconditions.checkArgument((!username.contains(":") ? 1 : 0) != 0, (Object)"Username must not contain a colon");
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        Preconditions.checkArgument((boolean)encoder.canEncode(username), (Object)"Username must be encoded in ISO-8859-1");
        Preconditions.checkArgument((boolean)encoder.canEncode(password), (Object)"Password must be encoded in ISO-8859-1");
        String credentials = username + ":" + password;
        Base64.Encoder base64 = Base64.getEncoder();
        byte[] bytes = credentials.getBytes(StandardCharsets.ISO_8859_1);
        this.authorization = "Basic " + base64.encodeToString(bytes);
    }

    @Override
    public String get() {
        return this.authorization;
    }
}

