/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.auth;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.zalando.riptide.auth.AuthorizationProvider;

public final class PlatformCredentialsAuthorizationProvider
implements AuthorizationProvider {
    private final Path type;
    private final Path secret;

    public PlatformCredentialsAuthorizationProvider(String name) {
        this(Paths.get("/meta/credentials", new String[0]), name);
    }

    public PlatformCredentialsAuthorizationProvider(Path directory, String name) {
        this(directory.resolve(name + "-token-type"), directory.resolve(name + "-token-secret"));
    }

    @Override
    public String get() throws IOException {
        return this.read(this.type) + " " + this.read(this.secret);
    }

    private String read(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        Preconditions.checkElementIndex((int)0, (int)lines.size(), (String)("Expected at least one line in " + path));
        return lines.get(0);
    }

    @Generated
    private PlatformCredentialsAuthorizationProvider(Path type, Path secret) {
        this.type = type;
        this.secret = secret;
    }
}

