/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.chaos;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.FauxPas;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.chaos.EmptyInputStream;
import org.zalando.riptide.chaos.FailureInjection;
import org.zalando.riptide.chaos.Probability;

@API(status=API.Status.EXPERIMENTAL)
public final class ErrorResponseInjection
implements FailureInjection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseInjection.class);
    private final Probability probability;
    private final List<HttpStatus> statuses;

    @Override
    public RequestExecution inject(RequestExecution execution) {
        if (this.probability.test()) {
            return arguments -> execution.execute(arguments).thenApply((Function)FauxPas.throwingFunction(this::injectIfNecessary));
        }
        return execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientHttpResponse injectIfNecessary(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        if (this.isError(statusCode)) {
            return response;
        }
        try {
            HttpStatus status = this.choose();
            log.debug("Injecting '{}' error response", (Object)status);
            ErrorClientHttpResponse errorClientHttpResponse = new ErrorClientHttpResponse(status);
            return errorClientHttpResponse;
        }
        finally {
            response.close();
        }
    }

    private boolean isError(HttpStatus status) {
        switch (status.series()) {
            case CLIENT_ERROR: 
            case SERVER_ERROR: {
                return true;
            }
        }
        return false;
    }

    private HttpStatus choose() {
        return this.statuses.get(ThreadLocalRandom.current().nextInt(this.statuses.size()));
    }

    @Generated
    public ErrorResponseInjection(Probability probability, List<HttpStatus> statuses) {
        this.probability = probability;
        this.statuses = statuses;
    }

    private static class ErrorClientHttpResponse
    implements ClientHttpResponse {
        private final HttpStatus status;

        @Nonnull
        public HttpStatus getStatusCode() {
            return this.status;
        }

        public int getRawStatusCode() {
            return this.status.value();
        }

        @Nonnull
        public String getStatusText() {
            return this.status.getReasonPhrase();
        }

        @Nonnull
        public HttpHeaders getHeaders() {
            return new HttpHeaders();
        }

        @Nonnull
        public InputStream getBody() {
            return EmptyInputStream.EMPTY;
        }

        public void close() {
        }

        @Generated
        public ErrorClientHttpResponse(HttpStatus status) {
            this.status = status;
        }
    }
}

