/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.chaos;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.chaos.FailureInjection;
import org.zalando.riptide.chaos.Probability;

@API(status=API.Status.EXPERIMENTAL)
public final class ExceptionInjection
implements FailureInjection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionInjection.class);
    private final Probability probability;
    private final List<Supplier<? extends Exception>> exceptions;

    @Override
    public RequestExecution inject(RequestExecution execution) {
        if (this.probability.test()) {
            return arguments -> {
                CompletableFuture future = execution.execute(arguments);
                return future.whenComplete((response, failure) -> {
                    if (failure == null) {
                        Exception exception = this.choose().get();
                        log.debug("Injecting '{}'", (Object)exception.getClass().getSimpleName());
                        throw new CompletionException(exception);
                    }
                });
            };
        }
        return execution;
    }

    private Supplier<? extends Exception> choose() {
        return this.exceptions.get(ThreadLocalRandom.current().nextInt(this.exceptions.size()));
    }

    @Generated
    public ExceptionInjection(Probability probability, List<Supplier<? extends Exception>> exceptions) {
        this.probability = probability;
        this.exceptions = exceptions;
    }
}

