/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.chaos;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.chaos.FailureInjection;
import org.zalando.riptide.chaos.Probability;
import org.zalando.riptide.chaos.Sleeper;

@API(status=API.Status.EXPERIMENTAL)
public final class LatencyInjection
implements FailureInjection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LatencyInjection.class);
    private final Sleeper sleepy = new Sleeper();
    private final Probability probability;
    private final Clock clock;
    private final Duration delay;

    @Override
    public RequestExecution inject(RequestExecution execution) {
        if (this.probability.test()) {
            return arguments -> {
                Instant start = this.clock.instant();
                return execution.execute(arguments).whenComplete((response, failure) -> {
                    Instant end = this.clock.instant();
                    Duration duration = Duration.between(start, end);
                    Duration rest = this.delay.minus(duration);
                    if (rest.isNegative()) {
                        return;
                    }
                    log.debug("Injecting latency of '{}' milliseconds", (Object)rest.toMillis());
                    this.sleepy.sleep(rest);
                });
            };
        }
        return execution;
    }

    @Generated
    public LatencyInjection(Probability probability, Clock clock, Duration delay) {
        this.probability = probability;
        this.clock = clock;
        this.delay = delay;
    }
}

