/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.compatibility;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestOperations;
import org.zalando.fauxpas.ThrowingConsumer;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Bindings;
import org.zalando.riptide.Http;
import org.zalando.riptide.Navigator;
import org.zalando.riptide.Navigators;
import org.zalando.riptide.PassRoute;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.Route;
import org.zalando.riptide.RoutingTree;
import org.zalando.riptide.Types;
import org.zalando.riptide.capture.Capture;
import org.zalando.riptide.compatibility.ExtractRoute;
import org.zalando.riptide.compatibility.HttpOutputMessageClientHttpRequestAdapter;
import org.zalando.riptide.compatibility.UriVariables;
import org.zalando.riptide.problem.ProblemRoute;

@Nonnull
@API(status=API.Status.EXPERIMENTAL)
public final class HttpOperations
implements RestOperations {
    private final Http http;
    private final RoutingTree<HttpStatus.Series> defaultRoutingTree;

    public HttpOperations(Http http) {
        this(http, (RoutingTree<HttpStatus.Series>)RoutingTree.dispatch((Navigator)Navigators.series(), (Binding[])new Binding[]{Bindings.anySeries().call(ProblemRoute.problemHandling())}));
    }

    public HttpOperations withDefaultRoutingTree(RoutingTree<HttpStatus.Series> defaultRoutingTree) {
        return new HttpOperations(this.http, defaultRoutingTree);
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, responseType, uriVariables).getBody();
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return (T)this.getForEntity(url, responseType, uriVariables).getBody();
    }

    public <T> T getForObject(URI url, Class<T> responseType) {
        return (T)this.getForEntity(url, responseType).getBody();
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... uriVariables) {
        return this.exchange(url, HttpMethod.GET, null, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.exchange(url, HttpMethod.GET, null, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) {
        return this.exchange(url, HttpMethod.GET, null, responseType);
    }

    @Nonnull
    public HttpHeaders headForHeaders(String url, Object ... uriVariables) {
        return this.execute(url, HttpMethod.HEAD, (HttpEntity)null, PassRoute.pass(), HttpMessage::getHeaders, uriVariables);
    }

    @Nonnull
    public HttpHeaders headForHeaders(String url, Map<String, ?> uriVariables) {
        return this.execute(url, HttpMethod.HEAD, (HttpEntity)null, PassRoute.pass(), HttpMessage::getHeaders, UriVariables.extract(url, uriVariables));
    }

    @Nonnull
    public HttpHeaders headForHeaders(URI url) {
        return this.execute(url, HttpMethod.HEAD, (HttpEntity)null, PassRoute.pass(), HttpMessage::getHeaders);
    }

    public URI postForLocation(String url, @Nullable Object body, Object ... uriVariables) {
        return this.postForEntity(url, body, Void.class, uriVariables).getHeaders().getLocation();
    }

    public URI postForLocation(String url, @Nullable Object body, Map<String, ?> uriVariables) {
        return this.postForEntity(url, body, Void.class, uriVariables).getHeaders().getLocation();
    }

    public URI postForLocation(URI url, @Nullable Object body) {
        return this.postForEntity(url, body, Void.class).getHeaders().getLocation();
    }

    public <T> T postForObject(String url, @Nullable Object body, Class<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, body, responseType, uriVariables).getBody();
    }

    public <T> T postForObject(String url, @Nullable Object body, Class<T> responseType, Map<String, ?> uriVariables) {
        return (T)this.postForEntity(url, body, responseType, uriVariables).getBody();
    }

    public <T> T postForObject(URI url, @Nullable Object body, Class<T> responseType) {
        return (T)this.postForEntity(url, body, responseType).getBody();
    }

    @Nonnull
    public <T> ResponseEntity<T> postForEntity(String url, @Nullable Object body, Class<T> responseType, Object ... uriVariables) {
        return this.exchange(url, HttpMethod.POST, new HttpEntity(body, null), responseType, uriVariables);
    }

    @Nonnull
    public <T> ResponseEntity<T> postForEntity(String url, @Nullable Object body, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.exchange(url, HttpMethod.POST, new HttpEntity(body, null), responseType, uriVariables);
    }

    @Nonnull
    public <T> ResponseEntity<T> postForEntity(URI url, @Nullable Object body, Class<T> responseType) {
        return this.exchange(url, HttpMethod.POST, new HttpEntity(body, null), responseType);
    }

    public void put(String url, @Nullable Object body, Object ... uriVariables) {
        this.exchange(url, HttpMethod.PUT, new HttpEntity(body, null), Void.class, uriVariables);
    }

    public void put(String url, @Nullable Object body, Map<String, ?> uriVariables) {
        this.exchange(url, HttpMethod.PUT, new HttpEntity(body, null), Void.class, uriVariables);
    }

    public void put(URI url, @Nullable Object body) {
        this.exchange(url, HttpMethod.PUT, new HttpEntity(body, null), Void.class);
    }

    public <T> T patchForObject(String url, @Nullable Object body, Class<T> responseType, Object ... uriVariables) {
        return (T)this.exchange(url, HttpMethod.PATCH, new HttpEntity(body, null), responseType, uriVariables).getBody();
    }

    public <T> T patchForObject(String url, @Nullable Object body, Class<T> responseType, Map<String, ?> uriVariables) {
        return (T)this.exchange(url, HttpMethod.PATCH, new HttpEntity(body, null), responseType, uriVariables).getBody();
    }

    public <T> T patchForObject(URI url, @Nullable Object body, Class<T> responseType) {
        return (T)this.exchange(url, HttpMethod.PATCH, new HttpEntity(body, null), responseType).getBody();
    }

    public void delete(String url, Object ... uriVariables) {
        this.exchange(url, HttpMethod.DELETE, null, Void.class, uriVariables);
    }

    public void delete(String url, Map<String, ?> uriVariables) {
        this.exchange(url, HttpMethod.DELETE, null, Void.class, uriVariables);
    }

    public void delete(URI url) {
        this.exchange(url, HttpMethod.DELETE, null, Void.class);
    }

    @Nonnull
    public Set<HttpMethod> optionsForAllow(String url, Object ... uriVariables) {
        return this.execute(url, HttpMethod.OPTIONS, (HttpEntity)null, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getAllow(), uriVariables);
    }

    @Nonnull
    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> uriVariables) {
        return this.execute(url, HttpMethod.OPTIONS, (HttpEntity)null, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getAllow(), UriVariables.extract(url, uriVariables));
    }

    @Nonnull
    public Set<HttpMethod> optionsForAllow(URI url) {
        return this.execute(url, HttpMethod.OPTIONS, (HttpEntity)null, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getAllow());
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, Class<T> responseType, Object ... uriVariables) {
        return this.exchange(url, method, entity, ParameterizedTypeReference.forType(responseType), uriVariables);
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.exchange(url, method, entity, ParameterizedTypeReference.forType(responseType), uriVariables);
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, Class<T> responseType) {
        return this.exchange(url, method, entity, ParameterizedTypeReference.forType(responseType));
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) {
        TypeToken type = TypeToken.of((Type)responseType.getType());
        return this.exchange(url, method, entity, type, uriVariables);
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        TypeToken type = TypeToken.of((Type)responseType.getType());
        return this.exchange(url, method, entity, type, UriVariables.extract(url, uriVariables));
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, ParameterizedTypeReference<T> responseType) {
        TypeToken type = TypeToken.of((Type)responseType.getType());
        return this.exchange(url, method, entity, type);
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(RequestEntity<?> entity, Class<T> responseType) {
        return this.exchange(entity, ParameterizedTypeReference.forType(responseType));
    }

    @Nonnull
    public <T> ResponseEntity<T> exchange(RequestEntity<?> entity, ParameterizedTypeReference<T> responseType) {
        HttpMethod method = entity.getMethod();
        Assert.notNull((Object)method, (String)"HttpMethod is required");
        TypeToken type = TypeToken.of((Type)responseType.getType());
        return this.exchange(entity.getUrl(), method, (HttpEntity<?>)entity, (TypeToken<T>)type);
    }

    public <T> T execute(String url, HttpMethod method, @Nullable RequestCallback callback, @Nullable ResponseExtractor<T> extractor, Object ... uriVariables) {
        Capture capture = Capture.empty();
        return this.execute(url, method, this.toEntity(callback), ExtractRoute.extractTo(extractor, capture), (Function<ClientHttpResponse, T>)capture, uriVariables);
    }

    public <T> T execute(String url, HttpMethod method, @Nullable RequestCallback callback, @Nullable ResponseExtractor<T> extractor, Map<String, ?> uriVariables) {
        Capture capture = Capture.empty();
        return this.execute(url, method, this.toEntity(callback), ExtractRoute.extractTo(extractor, capture), (Function<ClientHttpResponse, T>)capture, UriVariables.extract(url, uriVariables));
    }

    public <T> T execute(URI url, HttpMethod method, @Nullable RequestCallback callback, @Nullable ResponseExtractor<T> extractor) {
        Capture capture = Capture.empty();
        return this.execute(url, method, this.toEntity(callback), ExtractRoute.extractTo(extractor, capture), (Function<ClientHttpResponse, T>)capture);
    }

    private <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, TypeToken<T> type, Object[] uriVariables) {
        Capture capture = Capture.empty();
        return (ResponseEntity)this.execute(url, method, entity, Route.call((TypeToken)Types.responseEntityOf(type), (ThrowingConsumer)capture), (Function<ClientHttpResponse, T>)capture, uriVariables);
    }

    private <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, TypeToken<T> type) {
        Capture capture = Capture.empty();
        return (ResponseEntity)this.execute(url, method, entity, Route.call((TypeToken)Types.responseEntityOf(type), (ThrowingConsumer)capture), (Function<ClientHttpResponse, T>)capture);
    }

    private <T> T execute(String url, HttpMethod method, @Nullable HttpEntity<?> entity, Route route, Function<ClientHttpResponse, T> function, Object[] uriVariables) {
        return ((CompletableFuture)this.http.execute(method, url, uriVariables).headers((Map)this.getHeaders(entity)).body(this.getBody(entity)).call(this.route(route)).thenApply(function)).join();
    }

    private <T> T execute(String url, HttpMethod method, @Nullable RequestArguments.Entity entity, Route route, Function<ClientHttpResponse, T> function, Object[] uriVariables) {
        return ((CompletableFuture)this.http.execute(method, url, uriVariables).body(entity).call(this.route(route)).thenApply(function)).join();
    }

    private <T> T execute(URI url, HttpMethod method, @Nullable RequestArguments.Entity entity, Route route, Function<ClientHttpResponse, T> function) {
        return ((CompletableFuture)this.http.execute(method, url).body(entity).call(this.route(route)).thenApply(function)).join();
    }

    private <T> T execute(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, Route route, Function<ClientHttpResponse, T> function) {
        return ((CompletableFuture)this.http.execute(method, url).headers((Map)this.getHeaders(entity)).body(this.getBody(entity)).call(this.route(route)).thenApply(function)).join();
    }

    private HttpHeaders getHeaders(@Nullable HttpEntity<?> entity) {
        return entity == null ? HttpHeaders.EMPTY : entity.getHeaders();
    }

    private Object getBody(@Nullable HttpEntity<?> entity) {
        return entity == null ? null : entity.getBody();
    }

    private Route route(Route route) {
        return this.defaultRoutingTree.merge(Bindings.on((Object)HttpStatus.Series.SUCCESSFUL).call(route));
    }

    @Nullable
    private RequestArguments.Entity toEntity(@Nullable RequestCallback callback) {
        if (callback == null) {
            return null;
        }
        return message -> callback.doWithRequest((ClientHttpRequest)new HttpOutputMessageClientHttpRequestAdapter(message));
    }

    private HttpOperations(Http http, RoutingTree<HttpStatus.Series> defaultRoutingTree) {
        this.http = http;
        this.defaultRoutingTree = defaultRoutingTree;
    }
}

