/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.compatibility;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import org.springframework.util.concurrent.SuccessCallback;

final class CompletableToListenableFutureAdapter<T>
implements ListenableFuture<T> {
    private final Future<T> future;
    private final ListenableFutureCallbackRegistry<T> callbacks = new ListenableFutureCallbackRegistry();

    CompletableToListenableFutureAdapter(CompletableFuture<T> future) {
        this.future = future.whenComplete((result, e) -> {
            if (Objects.nonNull(result)) {
                this.callbacks.success(result);
            }
            if (Objects.nonNull(e)) {
                this.callbacks.failure(e);
            }
        });
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbacks.addCallback(callback);
    }

    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.callbacks.addSuccessCallback(successCallback);
        this.callbacks.addFailureCallback(failureCallback);
    }

    public boolean cancel(boolean arg0) {
        return this.future.cancel(arg0);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    public T get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(arg0, arg1);
    }
}

