/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.compatibility;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestOperations;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestOperations;
import org.zalando.fauxpas.ThrowingConsumer;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Bindings;
import org.zalando.riptide.Http;
import org.zalando.riptide.Navigator;
import org.zalando.riptide.Navigators;
import org.zalando.riptide.PassRoute;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.Route;
import org.zalando.riptide.RoutingTree;
import org.zalando.riptide.Types;
import org.zalando.riptide.capture.Capture;
import org.zalando.riptide.compatibility.CompletableToListenableFutureAdapter;
import org.zalando.riptide.compatibility.ExtractRoute;
import org.zalando.riptide.compatibility.HttpOperations;
import org.zalando.riptide.compatibility.HttpOutputMessageAsyncClientHttpRequestAdapter;
import org.zalando.riptide.compatibility.UriVariables;
import org.zalando.riptide.problem.ProblemRoute;

@Nonnull
@API(status=API.Status.EXPERIMENTAL)
public final class AsyncHttpOperations
implements AsyncRestOperations {
    private final Http http;
    private final RoutingTree<HttpStatus.Series> defaultRoutingTree;

    public AsyncHttpOperations(Http http) {
        this(http, (RoutingTree<HttpStatus.Series>)RoutingTree.dispatch((Navigator)Navigators.series(), (Binding[])new Binding[]{Bindings.anySeries().call(ProblemRoute.problemHandling())}));
    }

    public AsyncHttpOperations withDefaultRoutingTree(RoutingTree<HttpStatus.Series> defaultRoutingTree) {
        return new AsyncHttpOperations(this.http, defaultRoutingTree);
    }

    public RestOperations getRestOperations() {
        return new HttpOperations(this.http);
    }

    public <T> ListenableFuture<ResponseEntity<T>> getForEntity(String url, Class<T> responseType, Object ... uriVariables) {
        return this.exchange(url, HttpMethod.GET, null, responseType, uriVariables);
    }

    public <T> ListenableFuture<ResponseEntity<T>> getForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.exchange(url, HttpMethod.GET, null, responseType, uriVariables);
    }

    public <T> ListenableFuture<ResponseEntity<T>> getForEntity(URI url, Class<T> responseType) {
        return this.exchange(url, HttpMethod.GET, null, responseType);
    }

    public ListenableFuture<HttpHeaders> headForHeaders(String url, Object ... uriVariables) {
        return this.execute(url, HttpMethod.HEAD, PassRoute.pass(), HttpMessage::getHeaders, uriVariables);
    }

    @Nonnull
    public ListenableFuture<HttpHeaders> headForHeaders(String url, Map<String, ?> uriVariables) {
        return this.execute(url, HttpMethod.HEAD, PassRoute.pass(), HttpMessage::getHeaders, UriVariables.extract(url, uriVariables));
    }

    public ListenableFuture<HttpHeaders> headForHeaders(URI url) {
        return this.execute(url, HttpMethod.HEAD, PassRoute.pass(), HttpMessage::getHeaders);
    }

    public ListenableFuture<URI> postForLocation(String url, @Nullable HttpEntity<?> entity, Object ... uriVariables) {
        return this.execute(url, HttpMethod.POST, entity, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getLocation(), uriVariables);
    }

    @Nonnull
    public ListenableFuture<URI> postForLocation(String url, @Nullable HttpEntity<?> entity, Map<String, ?> uriVariables) {
        return this.execute(url, HttpMethod.POST, entity, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getLocation(), UriVariables.extract(url, uriVariables));
    }

    public ListenableFuture<URI> postForLocation(URI url, @Nullable HttpEntity<?> entity) {
        return this.execute(url, HttpMethod.POST, entity, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getLocation());
    }

    public <T> ListenableFuture<ResponseEntity<T>> postForEntity(String url, @Nullable HttpEntity<?> entity, Class<T> responseType, Object ... uriVariables) {
        Capture capture = Capture.empty();
        return this.execute(url, HttpMethod.POST, entity, Route.call((TypeToken)Types.responseEntityOf(responseType), (ThrowingConsumer)capture), (Function<ClientHttpResponse, T>)capture, uriVariables);
    }

    @Nonnull
    public <T> ListenableFuture<ResponseEntity<T>> postForEntity(String url, @Nullable HttpEntity<?> entity, Class<T> responseType, Map<String, ?> uriVariables) {
        Capture capture = Capture.empty();
        return this.execute(url, HttpMethod.POST, entity, Route.call((TypeToken)Types.responseEntityOf(responseType), (ThrowingConsumer)capture), (Function<ClientHttpResponse, T>)capture, UriVariables.extract(url, uriVariables));
    }

    public <T> ListenableFuture<ResponseEntity<T>> postForEntity(URI url, @Nullable HttpEntity<?> entity, Class<T> responseType) {
        return this.exchange(url, HttpMethod.POST, entity, responseType);
    }

    public ListenableFuture<?> put(String url, @Nullable HttpEntity<?> entity, Object ... uriVariables) {
        return this.exchange(url, HttpMethod.PUT, entity, Void.class, uriVariables);
    }

    public ListenableFuture<?> put(String url, @Nullable HttpEntity<?> entity, Map<String, ?> uriVariables) {
        return this.exchange(url, HttpMethod.PUT, entity, Void.class, uriVariables);
    }

    public ListenableFuture<?> put(URI url, @Nullable HttpEntity<?> entity) {
        return this.exchange(url, HttpMethod.PUT, entity, Void.class);
    }

    public ListenableFuture<?> delete(String url, Object ... uriVariables) {
        return this.execute(url, HttpMethod.DELETE, PassRoute.pass(), (ClientHttpResponse response) -> null, uriVariables);
    }

    public ListenableFuture<?> delete(String url, Map<String, ?> uriVariables) {
        return this.execute(url, HttpMethod.DELETE, PassRoute.pass(), (ClientHttpResponse response) -> null, UriVariables.extract(url, uriVariables));
    }

    public ListenableFuture<?> delete(URI url) {
        return this.execute(url, HttpMethod.DELETE, PassRoute.pass(), (ClientHttpResponse response) -> null);
    }

    public ListenableFuture<Set<HttpMethod>> optionsForAllow(String url, Object ... uriVariables) {
        return this.execute(url, HttpMethod.OPTIONS, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getAllow(), uriVariables);
    }

    public ListenableFuture<Set<HttpMethod>> optionsForAllow(String url, Map<String, ?> uriVariables) {
        return this.execute(url, HttpMethod.OPTIONS, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getAllow(), UriVariables.extract(url, uriVariables));
    }

    public ListenableFuture<Set<HttpMethod>> optionsForAllow(URI url) {
        return this.execute(url, HttpMethod.OPTIONS, PassRoute.pass(), (ClientHttpResponse response) -> response.getHeaders().getAllow());
    }

    public <T> ListenableFuture<ResponseEntity<T>> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, Class<T> responseType, Object ... uriVariables) {
        return this.exchange(url, method, entity, AsyncHttpOperations.forType(responseType), uriVariables);
    }

    public <T> ListenableFuture<ResponseEntity<T>> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.exchange(url, method, entity, AsyncHttpOperations.forType(responseType), uriVariables);
    }

    public <T> ListenableFuture<ResponseEntity<T>> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, Class<T> responseType) {
        return this.exchange(url, method, entity, AsyncHttpOperations.forType(responseType));
    }

    public <T> ListenableFuture<ResponseEntity<T>> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) {
        TypeToken type = TypeToken.of((Type)responseType.getType());
        return this.exchange(url, method, entity, type, uriVariables);
    }

    private <T> ListenableFuture<ResponseEntity<T>> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, TypeToken<T> type, Object ... uriVariables) {
        Capture capture = Capture.empty();
        return this.execute(url, method, entity, Route.call((TypeToken)Types.responseEntityOf(type), (ThrowingConsumer)capture), (Function<ClientHttpResponse, T>)capture, uriVariables);
    }

    public <T> ListenableFuture<ResponseEntity<T>> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> entity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        return this.exchange(url, method, entity, responseType, UriVariables.extract(url, uriVariables));
    }

    public <T> ListenableFuture<ResponseEntity<T>> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, ParameterizedTypeReference<T> responseType) {
        TypeToken type = TypeToken.of((Type)responseType.getType());
        return this.exchange(url, method, entity, type);
    }

    private <T> ListenableFuture<ResponseEntity<T>> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, TypeToken<T> type) {
        Capture capture = Capture.empty();
        return this.execute(url, method, entity, Route.call((TypeToken)Types.responseEntityOf(type), (ThrowingConsumer)capture), (Function<ClientHttpResponse, T>)capture);
    }

    public <T> ListenableFuture<T> execute(String url, HttpMethod method, @Nullable AsyncRequestCallback callback, @Nullable ResponseExtractor<T> extractor, Object ... uriVariables) {
        Capture capture = Capture.empty();
        return this.execute(url, method, this.toEntity(callback), this.route(ExtractRoute.extractTo(extractor, capture)), (Function<ClientHttpResponse, T>)capture, uriVariables);
    }

    @Nonnull
    public <T> ListenableFuture<T> execute(String url, HttpMethod method, @Nullable AsyncRequestCallback callback, @Nullable ResponseExtractor<T> extractor, Map<String, ?> uriVariables) {
        return this.execute(url, method, callback, extractor, UriVariables.extract(url, uriVariables));
    }

    @Nonnull
    public <T> ListenableFuture<T> execute(URI url, HttpMethod method, @Nullable AsyncRequestCallback callback, @Nullable ResponseExtractor<T> extractor) {
        Capture capture = Capture.empty();
        return this.execute(url, method, this.toEntity(callback), this.route(ExtractRoute.extractTo(extractor, capture)), (Function<ClientHttpResponse, T>)capture);
    }

    private static <T> ParameterizedTypeReference<T> forType(final Type type) {
        return new ParameterizedTypeReference<T>(){

            public Type getType() {
                return type;
            }
        };
    }

    private <T> ListenableFuture<T> execute(String url, HttpMethod method, Route route, Function<ClientHttpResponse, T> function, Object[] uriVariables) {
        return this.execute(url, method, (HttpEntity)null, route, function, uriVariables);
    }

    private <T> ListenableFuture<T> execute(String url, HttpMethod method, @Nullable HttpEntity<?> entity, Route route, Function<ClientHttpResponse, T> function, Object[] uriVariables) {
        CompletionStage future = this.http.execute(method, url, uriVariables).headers((Map)this.getHeaders(entity)).body(this.getBody(entity)).call(this.route(route)).thenApply(function);
        return new CompletableToListenableFutureAdapter(future);
    }

    private <T> ListenableFuture<T> execute(String url, HttpMethod method, @Nullable RequestArguments.Entity entity, Route route, Function<ClientHttpResponse, T> function, Object[] uriVariables) {
        CompletionStage future = this.http.execute(method, url, uriVariables).body(entity).call(this.route(route)).thenApply(function);
        return new CompletableToListenableFutureAdapter(future);
    }

    private <T> ListenableFuture<T> execute(URI url, HttpMethod method, Route route, Function<ClientHttpResponse, T> function) {
        return this.execute(url, method, (HttpEntity)null, route, function);
    }

    private <T> ListenableFuture<T> execute(URI url, HttpMethod method, @Nullable HttpEntity<?> entity, Route route, Function<ClientHttpResponse, T> function) {
        CompletionStage future = this.http.execute(method, url).headers((Map)this.getHeaders(entity)).body(this.getBody(entity)).call(this.route(route)).thenApply(function);
        return new CompletableToListenableFutureAdapter(future);
    }

    private <T> ListenableFuture<T> execute(URI url, HttpMethod method, @Nullable RequestArguments.Entity entity, Route route, Function<ClientHttpResponse, T> function) {
        CompletionStage future = this.http.execute(method, url).body(entity).call(this.route(route)).thenApply(function);
        return new CompletableToListenableFutureAdapter(future);
    }

    private HttpHeaders getHeaders(@Nullable HttpEntity<?> entity) {
        return entity == null ? new HttpHeaders() : entity.getHeaders();
    }

    private Object getBody(@Nullable HttpEntity<?> entity) {
        return entity == null ? null : entity.getBody();
    }

    private Route route(Route route) {
        return this.defaultRoutingTree.merge(Bindings.on((Object)HttpStatus.Series.SUCCESSFUL).call(route));
    }

    @Nullable
    private RequestArguments.Entity toEntity(@Nullable AsyncRequestCallback callback) {
        if (callback == null) {
            return null;
        }
        return message -> callback.doWithRequest((AsyncClientHttpRequest)new HttpOutputMessageAsyncClientHttpRequestAdapter(message));
    }

    @Generated
    private AsyncHttpOperations(Http http, RoutingTree<HttpStatus.Series> defaultRoutingTree) {
        this.http = http;
        this.defaultRoutingTree = defaultRoutingTree;
    }
}

