/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.CancelableCompletableFuture;
import org.zalando.riptide.ConditionalIdempotentMethodDetector;
import org.zalando.riptide.DefaultIdempotentMethodDetector;
import org.zalando.riptide.DefaultSafeMethodDetector;
import org.zalando.riptide.IdempotencyKeyIdempotentMethodDetector;
import org.zalando.riptide.MethodDetector;
import org.zalando.riptide.OverrideSafeMethodDetector;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.failsafe.RetryListener;

@API(status=API.Status.STABLE)
public final class FailsafePlugin
implements Plugin {
    private final ScheduledExecutorService scheduler;
    private final MethodDetector idempotent;
    private final RetryPolicy retryPolicy;
    private final CircuitBreaker circuitBreaker;
    private final RetryListener listener;

    public FailsafePlugin(ScheduledExecutorService scheduler) {
        this(scheduler, MethodDetector.compound((MethodDetector[])new MethodDetector[]{new DefaultIdempotentMethodDetector(MethodDetector.compound((MethodDetector[])new MethodDetector[]{new DefaultSafeMethodDetector(), new OverrideSafeMethodDetector()})), new ConditionalIdempotentMethodDetector(), new IdempotencyKeyIdempotentMethodDetector()}), null, null, RetryListener.DEFAULT);
    }

    public FailsafePlugin withIdempotentMethodDetector(MethodDetector detector) {
        return new FailsafePlugin(this.scheduler, detector, this.retryPolicy, this.circuitBreaker, this.listener);
    }

    public FailsafePlugin withRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        return new FailsafePlugin(this.scheduler, this.idempotent, retryPolicy, this.circuitBreaker, this.listener);
    }

    public FailsafePlugin withCircuitBreaker(@Nullable CircuitBreaker circuitBreaker) {
        return new FailsafePlugin(this.scheduler, this.idempotent, this.retryPolicy, circuitBreaker, this.listener);
    }

    public FailsafePlugin withListener(RetryListener listener) {
        return new FailsafePlugin(this.scheduler, this.idempotent, this.retryPolicy, this.circuitBreaker, listener);
    }

    public RequestExecution prepare(RequestArguments arguments, RequestExecution execution) {
        SyncFailsafe<Object> failsafe = this.select(this.retryPolicy, this.circuitBreaker, arguments);
        if (failsafe == null) {
            return execution;
        }
        return () -> {
            CompletableFuture original = ((AsyncFailsafe)failsafe.with(this.scheduler).with((Listeners)new RetryListenersAdapter(this.listener, arguments))).future(() -> ((RequestExecution)execution).execute());
            CompletableFuture cancelable = CancelableCompletableFuture.preserveCancelability((Future)original);
            original.whenComplete(CancelableCompletableFuture.forwardTo((CompletableFuture)cancelable));
            return cancelable;
        };
    }

    @Nullable
    private SyncFailsafe<Object> select(@Nullable RetryPolicy retryPolicy, @Nullable CircuitBreaker circuitBreaker, RequestArguments arguments) {
        if (retryPolicy != null && !this.idempotent.test(arguments)) {
            return this.select(null, circuitBreaker, arguments);
        }
        if (retryPolicy == null && circuitBreaker == null) {
            return null;
        }
        if (retryPolicy == null) {
            return Failsafe.with((CircuitBreaker)circuitBreaker);
        }
        if (circuitBreaker == null) {
            return Failsafe.with((RetryPolicy)retryPolicy);
        }
        return (SyncFailsafe)Failsafe.with((RetryPolicy)retryPolicy).with(circuitBreaker);
    }

    private FailsafePlugin(ScheduledExecutorService scheduler, MethodDetector idempotent, RetryPolicy retryPolicy, CircuitBreaker circuitBreaker, RetryListener listener) {
        this.scheduler = scheduler;
        this.idempotent = idempotent;
        this.retryPolicy = retryPolicy;
        this.circuitBreaker = circuitBreaker;
        this.listener = listener;
    }

    @VisibleForTesting
    static final class RetryListenersAdapter
    extends Listeners<ClientHttpResponse> {
        private final RequestArguments arguments;
        private RetryListener listener;

        public RetryListenersAdapter(RetryListener listener, RequestArguments arguments) {
            this.arguments = arguments;
            this.listener = listener;
        }

        public void onRetry(ClientHttpResponse result, Throwable failure, ExecutionContext context) {
            this.listener.onRetry(this.arguments, result, failure, context);
        }
    }
}

