/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.zalando.riptide.CancelableCompletableFuture;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.failsafe.RetryException;

public final class FailsafePlugin
implements Plugin {
    private static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private final ScheduledExecutorService scheduler;
    private final RetryPolicy retryPolicy;
    private final CircuitBreaker circuitBreaker;

    public FailsafePlugin(ScheduledExecutorService scheduler) {
        this(scheduler, NEVER, new CircuitBreaker());
    }

    FailsafePlugin(ScheduledExecutorService scheduler, RetryPolicy retryPolicy, CircuitBreaker circuitBreaker) {
        this.scheduler = scheduler;
        this.retryPolicy = retryPolicy;
        this.circuitBreaker = circuitBreaker;
    }

    public FailsafePlugin withRetryPolicy(RetryPolicy retryPolicy) {
        return new FailsafePlugin(this.scheduler, this.withRetryExceptionSupport(retryPolicy), this.circuitBreaker);
    }

    private RetryPolicy withRetryExceptionSupport(RetryPolicy retryPolicy) {
        return new RetryPolicy(retryPolicy).retryOn(RetryException.class);
    }

    public FailsafePlugin withCircuitBreaker(CircuitBreaker circuitBreaker) {
        return new FailsafePlugin(this.scheduler, this.retryPolicy, circuitBreaker);
    }

    public RequestExecution prepare(RequestArguments arguments, RequestExecution execution) {
        return () -> {
            CompletableFuture original = ((SyncFailsafe)Failsafe.with((RetryPolicy)this.retryPolicy).with(this.circuitBreaker)).with(this.scheduler).future(() -> ((RequestExecution)execution).execute());
            CompletableFuture cancelable = CancelableCompletableFuture.preserveCancelability((Future)original);
            original.whenComplete(CancelableCompletableFuture.forwardTo((CompletableFuture)cancelable));
            return cancelable;
        };
    }
}

