/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.time.Clock;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.util.Duration;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.riptide.HttpResponseException;

@API(status=API.Status.EXPERIMENTAL)
public final class RetryAfterDelayFunction
implements RetryPolicy.DelayFunction<Object, Throwable> {
    private static final Logger log = LoggerFactory.getLogger(RetryAfterDelayFunction.class);
    private final Pattern digit = Pattern.compile("\\d");
    private final Clock clock;

    public RetryAfterDelayFunction(Clock clock) {
        this.clock = clock;
    }

    public Duration computeDelay(Object result, Throwable failure, ExecutionContext context) {
        return failure instanceof HttpResponseException ? this.computeDelay((HttpResponseException)failure) : null;
    }

    @Nullable
    private Duration computeDelay(HttpResponseException failure) {
        String retryAfter = failure.getResponseHeaders().getFirst("Retry-After");
        return retryAfter == null ? null : this.toDuration(this.parseDelay(retryAfter));
    }

    @Nullable
    private Long parseDelay(String retryAfter) {
        return this.onlyDigits(retryAfter) ? this.parseSeconds(retryAfter) : this.secondsUntil(this.parseDate(retryAfter));
    }

    private boolean onlyDigits(String s) {
        return this.digit.matcher(s).matches();
    }

    private Long parseSeconds(String retryAfter) {
        return Long.parseLong(retryAfter);
    }

    @Nullable
    private Instant parseDate(String retryAfter) {
        try {
            return Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(retryAfter));
        }
        catch (DateTimeParseException e) {
            log.warn("Received invalid 'Retry-After' header [{}]; will ignore it", (Object)retryAfter);
            return null;
        }
    }

    @Nullable
    private Long secondsUntil(@Nullable Instant end) {
        return end == null ? null : Long.valueOf(java.time.Duration.between(Instant.now(this.clock), end).getSeconds());
    }

    @Nullable
    private Duration toDuration(@Nullable Long seconds) {
        return seconds == null ? null : new Duration(seconds.longValue(), TimeUnit.SECONDS);
    }
}

